/**
 * @(#)TopThree 31 October 2007
 *
 * @author Viera K. Proulx
 */
import java.util.*;

/**
 * A class designed to illustrate the use of type parameters
 * and the mutation of the <CODE>{@link ArrayList ArrayList}</CODE>.
 * Data consists of three elements ordered by the given 
 * <CODE>{@link Comparator Comparator}</CODE>.
 */
public class TopThree <T>{
 
  /**
   * An <CODE>ArrayList</CODE> to hold the three
   * data elements.
   */
  public ArrayList<T> all;
  /**
   * The comparator that defines the ordering of the elements.
   */
  public Comparator<T> comp;
  
  /**
   * The full constructor.
   */ 
  public TopThree(T one, T two, T three, Comparator<T> comp){
    this.all = new ArrayList<T>(3);
    this.all.add(0, one);
    this.all.add(1, two);
    this.all.add(2, three);
    this.comp = comp;
    this.reorder();
  }
  
  /**
   * Change each element to the given one and re-order the data.
   */ 
  public void reset(T d1, T d2, T d3){
    this.all.set(0, d1);
    this.all.set(1, d2);
    this.all.set(2, d3);
    this.reorder();
  }
  
  /**
   * Reorder the data using the 'resident' <CODE>Comparator</CODE>.
   */
  public void reorder(){
    T temp = this.all.get(0);
    if (this.comp.compare(this.all.get(0), this.all.get(1)) < 0){
      // ...
    } 
    // ...
  }
}