import java.util.*;
import tester.*;
import colors.*;

/**
 * The client class for the parametrized list classes, 
 * a <code>Traversal</code> wrapper for the <code>ArrayList</code>,
 * an <code>Algorithms</code> class that also uses the predicates that
 * implement the <code>ISelect</code> interface and examples of
 * these lists and methods using as data <code>Balloon</code> objects
 * 
 * @author Viera K. Proulx 
 * @since 17 March 2008
 */
public class Examples implements IExamples{
  
  public Examples(){}
  
  /** a big red <code>Balloon</code> */
  Balloon b1 = new Balloon(100, 200, 25, new Red());

  /** a small blue <code>Balloon</code> */
  Balloon b2 = new Balloon(200, 100, 20, new Blue());
  
  /** a big green <code>Balloon</code> */
  Balloon b3 = new Balloon(200, 150, 30, new Green());
  
  /** a small red <code>Balloon</code> */
  Balloon b4 = new Balloon(200, 120, 22, new Red());

  IList<Balloon> mtb = new MTList<Balloon>();
  
  /** a list with two red balloons and two small balloons */
  IList<Balloon> blist = new ConsList<Balloon>(b1,
      new ConsList<Balloon>(b2,
          new ConsList<Balloon>(b3,
              new ConsList<Balloon>(b4, this.mtb))));

  /** a list with no red balloons */
  IList<Balloon> blistNoRed = new ConsList<Balloon>(b2,
      new ConsList<Balloon>(b3, this.mtb));
 
  /** a list with no small balloons */
  IList<Balloon> blistNoSmall = new ConsList<Balloon>(b1,
      new ConsList<Balloon>(b3, this.mtb));
  
  /**
   * A method to construct an <code>ArrayList</code>
   * with four <code>Balloon</code>s 
   * 
   * @return an <code>ArrayList</code> with four <code>Balloon</code>s
   */
  public ArrayList<Balloon> makeArrBlist(){
    ArrayList<Balloon> arrlist = new ArrayList<Balloon>();
    arrlist.add(b1);
    arrlist.add(b2);
    arrlist.add(b3);
    arrlist.add(b4);
    return arrlist;
  }
  
  /**
   * A method to construct an <code>ArrayList</code>
   * with no red <code>Balloon</code>s 
   * 
   * @return an <code>ArrayList</code> with no red <code>Balloon</code>s
   */
  public ArrayList<Balloon> makeArrBlistNoRed(){
    ArrayList<Balloon> arrlist = new ArrayList<Balloon>();
    arrlist.add(b2);
    arrlist.add(b3);
    return arrlist;
  }
 
  /**
   * A method to construct an <code>ArrayList</code>
   * with no small <code>Balloon</code>s 
   * 
   * @return an <code>ArrayList</code> with no small <code>Balloon</code>s
   */
  public ArrayList<Balloon> makeArrBlistNoSmall(){
    ArrayList<Balloon> arrlist = new ArrayList<Balloon>();
    arrlist.add(b1);
    arrlist.add(b3);
    return arrlist;
  }
  
  /** a <code>Traversal</code> for <code>ArrayList</code>
   * with four <code>Balloon</code>s */
  ArrListTraversal<Balloon> arrblist = 
    new ArrListTraversal<Balloon>(this.makeArrBlist());

  /** a <code>Traversal</code> for <code>ArrayList</code>
   * with no red <code>Balloon</code>s */
  ArrListTraversal<Balloon> arrblistNoRed = 
    new ArrListTraversal<Balloon>(this.makeArrBlistNoRed());

  /** a <code>Traversal</code> for <code>ArrayList</code>
   * with no small <code>Balloon</code>s */
  ArrListTraversal<Balloon> arrblistNoSmall = 
    new ArrListTraversal<Balloon>(this.makeArrBlistNoSmall());

  
  /** Balloon class tests: equality */  
  public void testEquality(Tester t){   
    t.checkExpect(b2, new Balloon(200, 100, 20, new Blue()), 
        "the same balloons OK");
    t.checkExpect(b2, b2, "the same balloons OK");
  }
       
  /** Balloon class tests: the distanceFromTop method */ 
  public void testDistanceFromTop(Tester t){   
    t.checkExpect(b1.distanceFromTop(), 200 - 25, "distanceFromTop 1");    
    t.checkExpect(b2.distanceFromTop(), 80, "distanceFromTop 2");  
  }
  
  /** A predicate function object for red <code>Balloon</code>s */
  ISelect<Balloon>  redBalloon = new RedBalloon();
  
  /** A predicate function object for red <code>Balloon</code>s */
  ISelect<Balloon> smallBalloon = new SmallBalloon(23);
  
  /** ISelect classes tests: RedBalloon and SmallBalloon */ 
  public void testSelectors(Tester t){
    t.checkExpect(redBalloon.select(b1), true, "red balloon - true");
    t.checkExpect(redBalloon.select(b2), false, "red balloon - false");
    
    t.checkExpect(smallBalloon.select(b2), true, "small balloon - true");
    t.checkExpect(smallBalloon.select(b1), false, "small balloon - false");
  }
  
  /** An instance of the <code>Algorithms</code> class */
  Algorithms algo = new Algorithms();
  
  /** Algorithms methods tests: contains */ 
  public void testContains(Tester t){
    t.checkExpect(algo.contains(blist, redBalloon), true);
    t.checkExpect(algo.contains(blistNoRed, redBalloon), false);
    t.checkExpect(algo.contains(blist, smallBalloon), true);
    t.checkExpect(algo.contains(blistNoSmall, smallBalloon), false);
    

    t.checkExpect(algo.contains(arrblist, redBalloon), true);
    t.checkExpect(algo.contains(arrblistNoRed, redBalloon), false);
    t.checkExpect(algo.contains(arrblist, smallBalloon), true);
    t.checkExpect(algo.contains(arrblistNoSmall, smallBalloon), false);
  }

  /** Algorithms methods tests: countSuch */ 
  public void testCountSuch(Tester t){
    t.checkExpect(algo.countSuch(blist, redBalloon), 2);
    t.checkExpect(algo.countSuch(blist, smallBalloon), 2);

    t.checkExpect(algo.countSuch(arrblist, redBalloon), 2);
    t.checkExpect(algo.countSuch(arrblist, smallBalloon), 2);
  }
 
 
  /**
   * Run all tests
   * 
   * @param t the <CODE>{@link Tester Tester}</CODE> that performs the tests
   */
  public void tests(Tester t){
    
    testEquality(t);
    testDistanceFromTop(t);
    testSelectors(t);
    testContains(t);
    testCountSuch(t);
  }

}