import tester.*;

//-----------------------------------------------------------------------------
// Examples class for the Book class
public class Examples implements Testable{

  public Book book1 = new Book("DVC", 2002);
  public Book book2 = new Book("Beach", 1999);

  // combine all tests
  public void tests(Tester t){ 
    t.test("Book before a", book1.before(2000), false);
    t.test("Book before b", book2.before(2000), true);
  }

  // ------------ generate the test reports --------------------------------
  // add at the end of the Examples class
  public void go(){
    // create a new Tester to keep track of all test results
    Tester tester = new Tester();
    
    // run all tests
    tester.runTests(this);

    // print a short report - reporting only the failed tests
    System.out.println("Invoking t.testReport: \n");      
    tester.testReport();

    // print a full report - showing all expected and actual values 
    System.out.println("---------------------------------------------------");
    System.out.println("Invoking t.fullTestReport: \n");
    tester.fullTestReport();
  }

  public static void main(String[] argv){
    System.out.println("We are in the Examples class:");
    
    Examples e = new Examples();

    System.out.println("Show all data defined in the Examples class:");
    System.out.print(Inspector.makeString(e));

    System.out.println("\n\n---------------------------------------------------");
    System.out.println("Invoke tester.runTests(this):");
    e.go();
  }
}