import tester.*;
import geometry.Posn;


//-----------------------------------------------------------------------------
//examples
public class Examples implements Testable{

  // examples of data for the Blob class:
  Blob b1 = new Blob(new Posn(100, 100), 50);
  Blob b2 = b1.moveBlob("left");


  // test the method moveBlob
  public void testMoveBlob(Tester t){ 
    t.test("test moveBolb - left " + "\n",
        b1.moveBlob("left"), (new Blob(new Posn(80, 100), 50)));
    t.test("test movelob - right " + "\n",
        b1.moveBlob("right"), (new Blob(new Posn(120, 100), 50)));
    t.test("test moveBlob - up " + "\n",
        b1.moveBlob("up"), (new Blob(new Posn(100, 80), 50)));
    t.test("test moveBlob - down " + "\n",
        b1.moveBlob("down"), (new Blob(new Posn(100, 120), 50)));  
  }

  // test the method outsideBounds
  public void testOutsideBounds(Tester t){
    t.test("test testOutsideBounds "+ "\n",
        b1.outsideBounds(60, 200), true);
    t.test("test testOutsideBounds "+ "\n",
        b1.outsideBounds(100, 90), true);
    t.test("test testOutsideBounds "+ "\n",
        new Blob(new Posn(-5, 100), 50).outsideBounds(100, 110), true);
    t.test("test testOutsideBounds " + "\n",
        new Blob(new Posn(80, -5), 50).outsideBounds(100, 90), true);
    t.test("test testOutsideBounds "+ "\n",
        b1.outsideBounds(200, 400), false);
  }

  // combine all tests
  public void tests(Tester t){ 
    testMoveBlob(t);
    testOutsideBounds(t);
  }

  // run the world --------------------------------------------
  // construct an instance of a TimerWorld
  public TimerWorld w = new TimerWorld(new Blob(new Posn(100, 200), 20));

  // start the world 
  public boolean testWorld = w.bigBang(200, 400, 0.3);

  // ------------ generate the test reports --------------------------------
  // add at the end of the Examples class
  public void go(){
    Tester tester = new Tester();
    tester.runTests(this);

    System.out.println("Invoking t.testReport: \n");      
    tester.testReport();

    System.out.println("---------------------------------------------------");
    System.out.println("Invoking t.fullTestReport: \n");
    tester.fullTestReport();
  }

  /**
   * <P>Display all data defined in the <CODE>{@link Examples Examples}</CODE> 
   * class.</P>
   * <P>Run all tests defined in the <CODE>{@link Examples Examples}</CODE> 
   * class.</P>
   */
  public static void main(String[] argv){
    Examples e = new Examples();

    System.out.println("Show all data defined in the Examples class:");
    System.out.print(Inspector.makeString(e));

    System.out.println("\n\n---------------------------------------------------");
    System.out.println("Invoke tester.runTests(this):");
    e.go();
  }

}