/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import tester.Inspector;
import tester.Testable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tester {
    String testResults = "Test results: \n";
    String fullTestResults = "Full test results: \n";
    int n = 0;
    int errors = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTests(Testable testable) {
        this.n = 0;
        try {
            testable.tests(this);
        }
        catch (Throwable throwable) {
            ++this.errors;
            System.out.println("Threw exception during test " + this.n);
            System.out.println(throwable);
        }
        finally {
            this.done();
        }
    }

    public void done() {
        if (this.errors > 0) {
            System.out.print("Failed " + this.errors + " out of ");
        } else {
            System.out.print("Passed all ");
        }
        System.out.println(this.n + " tests.");
    }

    public void setTolerance(double d) {
        Inspector.TOLERANCE = d;
    }

    public boolean same(Object object, Object object2) {
        return Inspector.same(object, object2);
    }

    public void report(boolean bl, String string, Object object, Object object2) {
        if (bl) {
            this.reportSuccess(string, object, object2);
        } else {
            this.reportErrors(string, object, object2);
        }
    }

    public void test(String string, boolean bl) {
        if (!bl) {
            this.addError(string + ": error -- no blame -- \n");
        } else {
            this.addSuccess(string + ": success \n");
        }
    }

    public void test(String string, boolean bl, boolean bl2) {
        this.report(bl == bl2, string, "" + bl, "" + bl2);
    }

    public <T> void test(String string, T t, T t2) {
        this.report(Inspector.same(t, t2), string, t, t2);
    }

    public <T> void test(String string, T t, String string2, Object[] objectArray, Exception exception) {
        int n = Array.getLength(objectArray);
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        Class<?> clazz = exception.getClass();
        try {
            Method method = t.getClass().getMethod(string2, classArray);
            Object object = method.invoke(t, objectArray);
            this.addError(string + " : errors" + "\n invocation did not throw any exception " + "\n  method name: " + method.getName() + "\n  object class: " + t.getClass().getName() + "\n  result: " + object.getClass().getName() + ": " + Inspector.makeString(object) + "\n  expected exception was: \n    class: " + exception.getClass().getName() + "\n    message: " + exception.getMessage() + "\n\n");
        }
        catch (Throwable throwable) {
            if (throwable.getCause().getClass().getName().equals(clazz.getName())) {
                if (exception.getMessage().equals(throwable.getCause().getMessage())) {
                    this.addSuccess(string + " : success" + "\n correct exception: \n class: " + throwable.getCause().getClass().getName() + "\n correct message: " + throwable.getCause().getMessage() + "\n\n");
                } else {
                    this.addError(string + " : errors" + "\n correct exception: \n class: " + throwable.getCause().getClass().getName() + "\n incorrect message: " + throwable.getCause().getMessage() + "\n\n");
                }
            }
            this.addError(string + " : errors" + "\n incorrect exception was thrown: " + "\n    class of the thrown exception: " + throwable.getCause().getClass().getName() + "\n    class of the expected exception: " + exception.getClass().getName() + "\n\n");
        }
    }

    public <T> void test(String string, T t, String string2, Object[] objectArray) {
        int n = Array.getLength(objectArray);
        Class[] classArray = new Class[n];
        for (int i = 0; i < n; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        try {
            Method method = t.getClass().getMethod(string2, classArray);
            if (((Boolean)method.invoke(t, objectArray)).booleanValue()) {
                this.reportSuccess(string + "\n using " + string2 + " for comparison", t, Inspector.makeString(objectArray));
            } else {
                this.reportErrors(string + "\n using " + string2 + " for comparison", t, Inspector.makeString(objectArray));
            }
        }
        catch (Throwable throwable) {
            this.reportErrors(string + "\n using " + string2 + " for comparison" + "/nthrew an excception ", t, Inspector.makeString(objectArray));
        }
    }

    public void reportErrors(String string, Object object, Object object2) {
        this.addError(string + ": errors \n" + "actual: " + Inspector.makeString(object) + "\n" + "expected:   " + Inspector.makeString(object2) + "\n");
    }

    public void reportSuccess(String string, Object object, Object object2) {
        this.addSuccess(string + ": success \n" + "actual: " + Inspector.makeString(object) + "\n" + "expected:   " + Inspector.makeString(object2) + "\n");
    }

    public void addSuccess(String string) {
        this.fullTestResults = this.fullTestResults + "\n" + string;
        ++this.n;
    }

    public void addError(String string) {
        this.testResults = this.testResults + "\n" + string;
        this.fullTestResults = this.fullTestResults + "\n" + string;
        ++this.n;
        ++this.errors;
    }

    public void testReport() {
        if (this.errors == 1) {
            System.out.println(this.testResults + this.errors + " test failed.\n");
        } else if (this.errors > 1) {
            System.out.println(this.testResults + this.errors + " tests failed.\n");
        } else {
            System.out.println(this.testResults + "All tests passed.\n");
        }
    }

    public void fullTestReport() {
        if (this.errors == 1) {
            System.out.println("\n 1 test failed.\n");
        } else if (this.errors > 1) {
            System.out.println("\n " + this.errors + " tests failed.\n");
        } else {
            System.out.println("All tests passed.\n");
        }
        System.out.println(this.fullTestResults);
    }
}

