/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import tester.Inspector;

public class Reflector {
    Object sample;
    Class sampleClass;
    Field[] sampleDeclaredFields;

    Reflector(Object object) {
        this.sample = object;
        this.sampleClass = this.sample.getClass();
        this.sampleDeclaredFields = this.publicOrProtected(this.sample.getClass().getDeclaredFields());
    }

    public Field[] publicOrProtected(Field[] fieldArray) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : fieldArray) {
            if (!Modifier.isPublic(field.getModifiers()) && !Modifier.isProtected(field.getModifiers())) continue;
            arrayList.add(field);
        }
        Field[] fieldArray2 = new Field[arrayList.size()];
        return arrayList.toArray(fieldArray2);
    }

    protected void printInfo() {
        System.out.println("sample: " + this.sample);
        System.out.println("sampleClass: " + this.sampleClass);
        System.out.println("sampleDeclaredFields: \n");
        this.printSampleFields(this.sampleDeclaredFields);
    }

    protected void printSampleFields(Field[] fieldArray) {
        System.out.println("number of fields: " + Array.getLength(fieldArray) + "\n");
        for (Field field : fieldArray) {
            Class<?> clazz = field.getType();
            System.out.println("field name = " + field.getName() + "\nfield  type = " + clazz.getName());
            try {
                System.out.println("field value = " + field.get(this.sample) + "\n");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("printSampleFields cannot access the field  message: " + illegalAccessException.getMessage());
            }
        }
    }

    protected Field findField(String string) {
        for (Field field : this.sampleDeclaredFields) {
            if (!field.getName().equals(string)) continue;
            return field;
        }
        return null;
    }

    protected void show(String string) {
        Field field = this.findField(string);
        if (field == null) {
            System.out.println("Object " + string + " is not declared in this class.");
        } else {
            try {
                System.out.println("this." + string + " = " + Inspector.makeString(field.get(this.sample)));
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("the field " + field.getName() + "cannot be shown \n" + " message: " + illegalAccessException.getMessage());
            }
        }
    }

    protected Field findFieldWithValue(Object object) {
        for (Field field : this.sampleDeclaredFields) {
            try {
                if (!field.get(this.sample).equals(object)) continue;
                return field;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("findFieldWithValue cannot access the field " + field.getName() + " of the class " + this.sampleClass.getName() + "\n   message: " + illegalAccessException.getMessage());
            }
        }
        return null;
    }

    protected void showFieldWithValue(Object object) {
        Field field = this.findFieldWithValue(object);
        if (field == null) {
            System.out.println("Object " + object + " is not declared in this class.");
        } else {
            try {
                System.out.println("this." + field.getName() + " = " + Inspector.makeString(field.get(this.sample)));
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("the field " + field.getName() + "cannot be shown \n" + " message: " + illegalAccessException.getMessage());
            }
        }
    }
}

