/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Iterator;
import tester.ISame;
import tester.Reflector;

public class Inspector {
    Object sample;
    public static double TOLERANCE = 0.001;
    public static String INDENT = "  ";

    Inspector(Object object) {
        this.sample = object;
    }

    public static boolean same(Object object, Object object2) {
        Reflector reflector = new Reflector(object);
        Reflector reflector2 = new Reflector(object2);
        boolean bl = reflector.sampleClass.equals(reflector2.sampleClass);
        if (bl) {
            int n;
            if (reflector.sampleClass.getName().equals("java.lang.String")) {
                return object.equals(object2);
            }
            if (reflector.sampleClass.isPrimitive()) {
                if (Inspector.isInexact(reflector.sampleClass.getName())) {
                    return Inspector.sameInexact((Double)object, (Double)object2);
                }
                return object == object2;
            }
            if (Inspector.isWrapperClass(reflector.sampleClass.getName())) {
                if (Inspector.isInexact(reflector.sampleClass.getName())) {
                    return Inspector.sameInexact((Double)object, (Double)object2);
                }
                return object.equals(object2);
            }
            if (object instanceof Object[] && object2 instanceof Object[]) {
                int n2 = Array.getLength(object);
                if (Array.getLength(object2) == n2) {
                    for (int i = 0; i < n2; ++i) {
                        if (Inspector.same(((Object[])object)[i], ((Object[])object2)[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (object instanceof ISame && object2 instanceof ISame) {
                return ((ISame)object).same((ISame)object2);
            }
            if (object instanceof Iterable && object2 instanceof Iterable) {
                return Inspector.sameIterable((Iterable)object, (Iterable)object2);
            }
            boolean bl2 = true;
            try {
                for (n = 0; n < Array.getLength(reflector.sampleDeclaredFields); ++n) {
                    bl2 = bl2 && Inspector.same(reflector.sampleDeclaredFields[n].get(object), reflector2.sampleDeclaredFields[n].get(object2));
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("same comparing " + reflector.sampleDeclaredFields[n].getType().getName() + " and " + reflector2.sampleDeclaredFields[n].getType().getName() + "cannot access the field " + n + " message: " + illegalAccessException.getMessage());
                System.out.println("class 1: " + reflector.sampleClass.getName());
                System.out.println("class 2: " + reflector2.sampleClass.getName());
            }
            return bl2;
        }
        return false;
    }

    public static boolean sameInexact(double d, double d2) {
        if (d - d2 == 0.0) {
            return true;
        }
        return Math.abs(d - d2) / Math.max(Math.abs(d), Math.abs(d2)) < TOLERANCE;
    }

    public static boolean sameIterable(Iterable iterable, Iterable iterable2) {
        Iterator iterator = iterable.iterator();
        Iterator iterator2 = iterable2.iterator();
        return Inspector.sameData(iterator, iterator2);
    }

    public static boolean sameData(Iterator iterator, Iterator iterator2) {
        if (!iterator.hasNext()) {
            return !iterator2.hasNext();
        }
        if (!iterator2.hasNext()) {
            return false;
        }
        return Inspector.same(iterator.next(), iterator2.next()) && Inspector.sameData(iterator, iterator2);
    }

    public static boolean isInexact(String string) {
        return string.equals("double") || string.equals("float") || string.equals("java.lang.Double") || string.equals("java.lang.Float");
    }

    public static boolean isWrapperClass(String string) {
        return string.equals("java.lang.Integer") || string.equals("java.lang.Long") || string.equals("java.lang.Short") || string.equals("java.math.BigInteger") || string.equals("java.math.BigDecimal") || string.equals("java.lang.Float") || string.equals("java.lang.Double") || string.equals("java.lang.Byte") || string.equals("java.lang.Boolean") || string.equals("java.lang.Character");
    }

    public static String makeString(Object object) {
        if (object instanceof String) {
            return "\"" + object.toString() + "\"";
        }
        Class<?> clazz = object.getClass();
        if (clazz.isPrimitive() || Inspector.isWrapperClass(clazz.getName())) {
            return object.toString();
        }
        if (object instanceof Object[]) {
            String string = "\n" + INDENT + " new Object[]()";
            INDENT = INDENT + "  ";
            for (int i = 0; i < Array.getLength(object); ++i) {
                string = string + "){" + Inspector.makeString(((Object[])object)[i]) + ",";
            }
            if (Array.getLength(object) > 0) {
                string = string.substring(0, string.length() - 1);
            }
            INDENT = INDENT.substring(0, INDENT.length() - 2);
            string = string + "}";
            return string;
        }
        String string = "\n" + INDENT + " new " + clazz.getName() + "(";
        INDENT = INDENT + "  ";
        if (object instanceof Iterable) {
            string = string + "){" + Inspector.makeIterableStrings(((Iterable)object).iterator()) + "}";
        } else {
            Reflector reflector = new Reflector(object);
            for (Field field : reflector.sampleDeclaredFields) {
                try {
                    String string2 = "this." + field.getName() + " = " + Inspector.makeString(field.get(object));
                    string = string + "\n" + INDENT + string2;
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("makeString cannot access the field " + field.getName() + " of the class " + reflector.sampleClass.getName() + "\n   message: " + illegalAccessException.getMessage());
                }
            }
            string = string + ")";
        }
        INDENT = INDENT.substring(0, INDENT.length() - 2);
        return string;
    }

    public static String makeIterableStrings(Iterator iterator) {
        String string = "";
        while (iterator.hasNext()) {
            string = string + Inspector.makeString(iterator.next()) + ",";
        }
        if (string.length() > 0) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }
}

