/*
 * Decompiled with CFR 0.152.
 */
package draw;

import draw.Canvas;
import draw.MyKeyAdapter;
import draw.MyMouseAdapter;
import draw.MyTimer;
import geometry.Posn;

public class World {
    public Canvas theCanvas;
    private boolean worldExists = false;
    private MyTimer mytime;
    private MyKeyAdapter ka;
    private MyMouseAdapter ma;

    public boolean bigBang(int n, int n2, double d) {
        this.theCanvas = new Canvas(n, n2);
        this.worldExists = true;
        this.ka = new MyKeyAdapter(this);
        this.theCanvas.f.addKeyListener(this.ka);
        this.ma = new MyMouseAdapter(this);
        this.theCanvas.f.addMouseListener(this.ma);
        this.mytime = new MyTimer(this, d);
        if (d > 0.0) {
            this.mytime.timer.start();
        }
        this.theCanvas.show();
        this.draw();
        return true;
    }

    public World endOfWorld(String string) {
        System.out.println("The end of the world: " + string);
        this.mytime.timer.stop();
        this.worldExists = false;
        this.theCanvas.f.removeKeyListener(this.ka);
        this.theCanvas.f.removeMouseListener(this.ma);
        this.draw();
        this.theCanvas.drawString(string, new Posn(10, 20));
        return this;
    }

    public boolean endOfTime(String string) {
        System.out.println("The world stopped: " + string);
        this.mytime.timer.stop();
        this.worldExists = false;
        this.theCanvas.f.removeKeyListener(this.ka);
        this.theCanvas.f.removeMouseListener(this.ma);
        this.theCanvas.drawString(string, new Posn(10, 20));
        return this.draw();
    }

    protected World processTick() {
        World world = this.onTick();
        return this.resetWorld(world);
    }

    public World onTick() {
        return this;
    }

    protected World processKeyEvent(String string) {
        World world = this.onKeyEvent(string);
        return this.resetWorld(world);
    }

    public World onKeyEvent(String string) {
        return this;
    }

    protected World processMouseClicked(Posn posn) {
        World world = this.onMouseClick(posn);
        return this.resetWorld(world);
    }

    public World onMouseClick(Posn posn) {
        return this;
    }

    protected World processMouseEntered(Posn posn) {
        World world = this.onMouseEntered(posn);
        return this.resetWorld(world);
    }

    public World onMouseEntered(Posn posn) {
        return this;
    }

    protected World processMouseExited(Posn posn) {
        World world = this.onMouseExited(posn);
        return this.resetWorld(world);
    }

    public World onMouseExited(Posn posn) {
        return this;
    }

    protected World processMousePressed(Posn posn) {
        World world = this.onMousePressed(posn);
        return this.resetWorld(world);
    }

    public World onMousePressed(Posn posn) {
        return this;
    }

    protected World processMouseReleased(Posn posn) {
        World world = this.onMouseReleased(posn);
        return this.resetWorld(world);
    }

    public World onMouseReleased(Posn posn) {
        return this;
    }

    private World resetWorld(World world) {
        world.theCanvas = this.theCanvas;
        world.worldExists = true;
        world.ka = this.ka;
        world.ka.currentWorld = world;
        world.ma = this.ma;
        world.ma.currentWorld = world;
        world.mytime = this.mytime;
        world.mytime.setSpeed();
        world.mytime.currentWorld = world;
        world.drawWorld();
        return world;
    }

    protected boolean drawWorld() {
        if (this.worldExists) {
            return this.draw();
        }
        return true;
    }

    public boolean draw() {
        return true;
    }

    protected boolean eraseWorld() {
        if (this.worldExists) {
            return this.erase();
        }
        return true;
    }

    public boolean erase() {
        return true;
    }
}

