/*
 * Decompiled with CFR 0.152.
 */
package draw;

import colors.Black;
import colors.White;
import draw.Canvas;
import geometry.Posn;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.IOException;
import javax.swing.JPanel;

class CanvasPanel
extends JPanel {
    protected CanvasPanel(int n, int n2) {
        this.setPreferredSize(new Dimension(n, n2));
        this.addNotify();
    }

    protected void paintComponent(Graphics graphics) {
    }

    protected void drawDisk(Posn posn, int n, Color color) {
        Graphics graphics = this.getGraphics();
        graphics.setColor(color);
        graphics.fillOval(posn.x - n, posn.y - n, 2 * n, 2 * n);
    }

    protected void drawCircle(Posn posn, int n, Color color) {
        Graphics graphics = this.getGraphics();
        graphics.setColor(color);
        graphics.drawOval(posn.x - n, posn.y - n, 2 * n, 2 * n);
    }

    protected void drawRect(Posn posn, int n, int n2, Color color) {
        Graphics graphics = this.getGraphics();
        graphics.setColor(color);
        graphics.fillRect(posn.x, posn.y, n, n2);
    }

    protected void drawLine(Posn posn, Posn posn2, Color color) {
        Graphics graphics = this.getGraphics();
        graphics.setColor(color);
        graphics.drawLine(posn.x, posn.y, posn2.x, posn2.y);
    }

    protected void drawString(String string, Posn posn) {
        Graphics graphics = this.getGraphics();
        graphics.setColor((Color)new Black());
        graphics.drawString(string, posn.x, posn.y);
    }

    protected void eraseString(String string, Posn posn) {
        Graphics graphics = this.getGraphics();
        graphics.setColor((Color)new White());
        graphics.drawString(string, posn.x, posn.y);
    }

    protected void drawBackground() {
        Graphics graphics = this.getGraphics();
        Dimension dimension = this.getPreferredSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    protected void erase() {
        Graphics graphics = this.getGraphics();
        Dimension dimension = this.getPreferredSize();
        graphics.setColor((Color)new White());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    public static void nextStep(String string) {
        try {
            System.out.println(string);
            System.out.println("Press RETURN");
            int n = System.in.read();
        }
        catch (IOException iOException) {
            System.out.println("Next step");
        }
    }

    public static void main(String[] stringArray) {
        CanvasPanel.nextStep("Canvas with default name is constructed");
        Canvas canvas = new Canvas(200, 200);
        CanvasPanel.nextStep("To show the canvas ... ");
        canvas.show();
        CanvasPanel.nextStep("Canvas shown - should be blank - add red and blue disk");
        boolean bl = canvas.drawDisk(new Posn(50, 50), 20, Color.red) && canvas.drawDisk(new Posn(150, 50), 50, Color.blue);
        CanvasPanel.nextStep("Show the canvas again - it should not do anything");
        canvas.show();
        CanvasPanel.nextStep("Draw a green disk");
        boolean bl2 = canvas.drawDisk(new Posn(50, 150), 50, Color.green);
        CanvasPanel.nextStep("Close the Canvas");
        canvas.close();
        CanvasPanel.nextStep("Show the canvas again - it should be cleared");
        canvas.show();
        CanvasPanel.nextStep("Paint one disks on the canvas");
        boolean bl3 = canvas.drawDisk(new Posn(50, 150), 25, Color.black);
        CanvasPanel.nextStep("Construct a second canvas with the name Smiley");
        Canvas canvas2 = new Canvas(200, 200, "Smiley");
        CanvasPanel.nextStep("Show the second canvas");
        canvas2.show();
        CanvasPanel.nextStep("Paint two disks on the Smiley canvas");
        boolean bl4 = canvas2.drawDisk(new Posn(50, 50), 20, Color.red) && canvas2.drawDisk(new Posn(150, 150), 50, Color.blue);
        CanvasPanel.nextStep("Manually close the 'Canvas' windowand see if we can bring it back to life");
        canvas.show();
        CanvasPanel.nextStep("The first canvas should be shown - cleared");
        boolean bl5 = canvas.drawDisk(new Posn(50, 50), 30, Color.red) && canvas.drawDisk(new Posn(150, 50), 30, Color.blue) && canvas.drawDisk(new Posn(50, 150), 30, Color.green);
        CanvasPanel.nextStep("The first canvas has three disks drawn");
        System.out.println("Close both canvas windows to end the program");
    }
}

