/*
 * Decompiled with CFR 0.152.
 */
package draw;

import colors.White;
import draw.CanvasPanel;
import geometry.Posn;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class Canvas {
    protected static int WINDOWS_OPEN = 0;
    protected JFrame f;
    protected Component panel;
    public int width;
    public int height;

    public Canvas(int n, int n2, String string) {
        this.width = n;
        this.height = n2;
        this.f = new JFrame(string);
        this.f.setLayout(new BorderLayout());
        this.f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (--WINDOWS_OPEN == 0) {
                    System.exit(0);
                }
            }
        });
        this.f.setDefaultCloseOperation(1);
        this.panel = new CanvasPanel(n, n2);
        this.panel.addNotify();
        this.panel.setBackground(Color.yellow);
        this.f.getContentPane().add(this.panel, "Center");
        this.f.pack();
        Graphics graphics = this.panel.getGraphics();
        this.f.update(graphics);
        ((CanvasPanel)this.panel).erase();
        this.f.update(graphics);
        this.f.setVisible(false);
    }

    public Canvas(int n, int n2) {
        this(n, n2, "Canvas");
    }

    public boolean drawDisk(Posn posn, int n, Color color) {
        ((CanvasPanel)this.panel).drawDisk(posn, n, color);
        return true;
    }

    public boolean eraseDisk(Posn posn, int n, Color color) {
        ((CanvasPanel)this.panel).drawDisk(posn, n, (Color)new White());
        return true;
    }

    public boolean drawCircle(Posn posn, int n, Color color) {
        ((CanvasPanel)this.panel).drawCircle(posn, n, color);
        return true;
    }

    public boolean eraseCircle(Posn posn, int n, Color color) {
        ((CanvasPanel)this.panel).drawCircle(posn, n, (Color)new White());
        return true;
    }

    public boolean drawRect(Posn posn, int n, int n2, Color color) {
        ((CanvasPanel)this.panel).drawRect(posn, n, n2, color);
        return true;
    }

    public boolean eraseRect(Posn posn, int n, int n2, Color color) {
        ((CanvasPanel)this.panel).drawRect(posn, n, n2, (Color)new White());
        return true;
    }

    public boolean drawLine(Posn posn, Posn posn2, Color color) {
        ((CanvasPanel)this.panel).drawLine(posn, posn2, color);
        return true;
    }

    public boolean eraseLine(Posn posn, Posn posn2, Color color) {
        ((CanvasPanel)this.panel).drawLine(posn, posn2, (Color)new White());
        return true;
    }

    public boolean drawString(String string, Posn posn) {
        ((CanvasPanel)this.panel).drawString(string, posn);
        return true;
    }

    public boolean eraseString(String string, Posn posn) {
        ((CanvasPanel)this.panel).eraseString(string, posn);
        return true;
    }

    public boolean erase() {
        ((CanvasPanel)this.panel).erase();
        return true;
    }

    public boolean show() {
        if (!this.f.isVisible()) {
            ++WINDOWS_OPEN;
            this.f.setVisible(true);
            ((CanvasPanel)this.panel).erase();
            return true;
        }
        return true;
    }

    public boolean close() {
        if (this.f.isVisible()) {
            --WINDOWS_OPEN;
            this.f.setVisible(false);
        }
        return true;
    }
}

