/*
 * Decompiled with CFR 0.152.
 */
package draw;

import colors.White;
import draw.SmallWorld;
import geometry.Posn;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Timer;

public class BigWorld
extends Frame
implements KeyListener,
MouseListener {
    protected Image img;
    protected Graphics bg;
    public Posn mousePosn = new Posn(0, 0);
    protected SmallWorld littleWorld;
    protected static BigWorld theWorld = new BigWorld();
    protected static final String newline = "\n";
    protected static boolean WORLD_OK = true;
    protected double speed;
    private ActionListener timerTasks = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            BigWorld.this.littleWorld.erase();
            BigWorld.this.littleWorld = BigWorld.this.littleWorld.onTickEvent();
            if (WORLD_OK) {
                BigWorld.this.littleWorld.draw();
            }
        }
    };
    private Timer timer;

    protected BigWorld() {
    }

    protected boolean bigBang(double speed, SmallWorld littleWorld, boolean key, boolean mouse) {
        BigWorld.theWorld.littleWorld = littleWorld;
        BigWorld.theWorld.timer = new Timer(1000, this.timerTasks);
        BigWorld.theWorld.speed = speed;
        BigWorld.theWorld.timer.setDelay(this.delay(speed));
        if (mouse) {
            theWorld.addMouseListener(theWorld);
        }
        if (key) {
            theWorld.addKeyListener(theWorld);
        }
        if (speed != 0.0) {
            BigWorld.theWorld.timer.start();
        }
        return BigWorld.theWorld.littleWorld.draw() && BigWorld.theWorld.littleWorld.draw();
    }

    private int delay(double speed) {
        return new Double(speed * 1000.0).intValue();
    }

    public void keyTyped(KeyEvent e) {
        this.displayInfo(e, "KEY TYPED: ");
    }

    public void keyPressed(KeyEvent e) {
        this.displayInfo(e, "KEY PRESSED: ");
    }

    public void keyReleased(KeyEvent e) {
        this.displayInfo(e, "KEY RELEASED: ");
    }

    protected void displayInfo(KeyEvent e, String s) {
        String keyString = "";
        String[] arrows = new String[]{"left", "up", "right", "down"};
        int id = e.getID();
        if (id == 400) {
            char c = e.getKeyChar();
            keyString = "" + c;
        } else if (id == 401) {
            int keyCode = e.getKeyCode();
            if (keyCode <= 40 && keyCode >= 37) {
                keyString = KeyEvent.getKeyText(keyCode).toLowerCase();
            }
        } else {
            keyString = "released";
        }
        this.littleWorld.erase();
        this.littleWorld = this.littleWorld.onKeyEvent(keyString);
        if (WORLD_OK) {
            this.littleWorld.draw();
        }
        int modifiers = e.getModifiersEx();
        String modString = "modifiers = " + modifiers;
        String tmpString = KeyEvent.getModifiersExText(modifiers);
        modString = tmpString.length() > 0 ? String.valueOf(modString) + " (" + tmpString + ")" : String.valueOf(modString) + " (no modifiers)";
        String actionString = "action key? ";
        actionString = e.isActionKey() ? String.valueOf(actionString) + "YES" : String.valueOf(actionString) + "NO";
        String locationString = "key location: ";
        int location = e.getKeyLocation();
        locationString = location == 1 ? String.valueOf(locationString) + "standard" : (location == 2 ? String.valueOf(locationString) + "left" : (location == 3 ? String.valueOf(locationString) + "right" : (location == 4 ? String.valueOf(locationString) + "numpad" : String.valueOf(locationString) + "unknown")));
    }

    public void mouseClicked(MouseEvent e) {
        this.littleWorld.erase();
        this.littleWorld = this.littleWorld.mouseClicked(new Posn(e.getX(), e.getY()));
        this.littleWorld.draw();
    }

    public void mouseEntered(MouseEvent e) {
        this.littleWorld.mousePosn = new Posn(e.getX(), e.getY());
        this.littleWorld.erase();
        this.littleWorld = this.littleWorld.mouseEntered();
        if (WORLD_OK) {
            this.littleWorld.draw();
        }
    }

    public void mouseExited(MouseEvent e) {
        this.littleWorld.mousePosn = new Posn(e.getX(), e.getY());
        this.littleWorld.erase();
        this.littleWorld = this.littleWorld.mouseExited();
        if (WORLD_OK) {
            this.littleWorld.draw();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.littleWorld.mousePosn = new Posn(e.getX(), e.getY());
        this.littleWorld.erase();
        this.littleWorld = this.littleWorld.mousePressed();
        if (WORLD_OK) {
            this.littleWorld.draw();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.littleWorld.mousePosn = new Posn(e.getX(), e.getY());
        this.littleWorld.erase();
        this.littleWorld = this.littleWorld.mouseReleased();
        if (WORLD_OK) {
            this.littleWorld.draw();
        }
    }

    protected boolean start(int width, int height) {
        this.addNotify();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setBounds(0, 0, width, height);
        this.img = this.createImage(width, height);
        this.bg = this.img.getGraphics();
        theWorld.setVisible(true);
        return true;
    }

    protected boolean close() {
        theWorld.setVisible(false);
        this.removeNotify();
        return true;
    }

    public boolean endOfTime() {
        System.out.println("End of Time");
        this.timer.stop();
        return true;
    }

    public SmallWorld endOfWorldEvent() {
        System.out.println("Exit");
        this.timer.stop();
        theWorld.removeKeyListener(theWorld);
        theWorld.removeMouseListener(theWorld);
        theWorld.close();
        WORLD_OK = false;
        return this.littleWorld;
    }

    public boolean erase() {
        Rectangle r = theWorld.getBounds();
        return theWorld.drawRect(new Posn(0, 0), r.width, r.height, (Color)new White());
    }

    public boolean draw() {
        return true;
    }

    protected boolean drawCircle(Posn p, int r, Color c) {
        int x = p.x;
        int y = p.y;
        this.bg.setColor(c);
        this.bg.drawOval(x - r, y - r, 2 * r, 2 * r);
        return true;
    }

    protected boolean drawDisk(Posn p, int r, Color c) {
        int x = p.x;
        int y = p.y;
        this.bg.setColor(c);
        this.bg.fillOval(x - r, y - r, 2 * r, 2 * r);
        return true;
    }

    protected boolean drawRect(Posn p, int width, int height, Color c) {
        int x = p.x;
        int y = p.y;
        this.bg.setColor(c);
        this.bg.fillRect(x, y, width, height);
        return true;
    }

    protected boolean drawLine(Posn p0, Posn p1, Color c) {
        int x0 = p0.x;
        int y0 = p0.y;
        int x1 = p1.x;
        int y1 = p1.y;
        this.bg.setColor(c);
        this.bg.drawLine(x0, y0, x1, y1);
        return true;
    }

    protected boolean drawString(Posn p, String s) {
        int x = p.x;
        int y = p.y;
        char[] data = s.toCharArray();
        this.bg.setColor(Color.black);
        this.bg.drawChars(data, 0, s.length(), x, y);
        return true;
    }

    protected boolean clearCircle(Posn p, int r, Color c) {
        int x = p.x;
        int y = p.y;
        this.bg.setColor(Color.white);
        this.bg.drawOval(x - r, y - r, 2 * r, 2 * r);
        return true;
    }

    protected boolean clearDisk(Posn p, int r, Color c) {
        int x = p.x;
        int y = p.y;
        this.bg.setColor(Color.white);
        this.bg.fillOval(x - r, y - r, 2 * r, 2 * r);
        return true;
    }

    protected boolean clearRect(Posn p, int width, int height, Color c) {
        int x = p.x;
        int y = p.y;
        this.bg.setColor((Color)new White());
        this.bg.fillRect(x, y, width, height);
        return true;
    }

    protected boolean clearLine(Posn p0, Posn p1, Color c) {
        int x0 = p0.x;
        int y0 = p0.y;
        int x1 = p1.x;
        int y1 = p1.y;
        this.bg.setColor((Color)new White());
        this.bg.drawLine(x0, y0, x1, y1);
        return true;
    }

    protected boolean clearString(Posn p, String s) {
        int x = p.x;
        int y = p.y;
        char[] data = s.toCharArray();
        this.bg.setColor(Color.white);
        this.bg.drawChars(data, 0, s.length(), x, y);
        return true;
    }

    protected boolean setColor(Color c) {
        this.bg.setColor(c);
        return true;
    }

    protected boolean paintWorld() {
        this.paint(this.bg);
        return true;
    }

    public void paint(Graphics g) {
        g.drawImage(this.img, 0, 0, this);
    }

    public boolean sleepForAWhile(int s) {
        int rounds = 100000000 * s;
        int i = 0;
        while (i < rounds) {
            ++i;
        }
        return true;
    }

    public static void main(String[] argv) {
        SmallWorld c = new SmallWorld();
        c.start(300, 300);
        c.sleepForAWhile(2);
        c.bigBang(0.5);
        c.drawRect(new Posn(30, 30), 100, 100, Color.red);
        c.sleepForAWhile(2);
        c.drawCircle(new Posn(30, 30), 100, Color.green);
        c.sleepForAWhile(2);
        c.drawDisk(new Posn(80, 80), 100, Color.blue);
        c.sleepForAWhile(2);
        c.endOfTime();
    }
}

