/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.FocusActionAdapter;
import edu.neu.ccs.gui.Laminate;
import edu.neu.ccs.gui.MouseAction;
import edu.neu.ccs.gui.MouseActionAdapter;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.ZooContainer;
import edu.neu.ccs.gui.ZooGroup;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;

public class Zoo
extends ZooContainer {
    protected MouseActionAdapter mouseAdapter = null;
    protected Hashtable laminateTable = new Hashtable();
    protected ListSelectionModel selectionModel = null;
    protected boolean restrictingBounds = true;
    protected boolean moveable = true;
    protected boolean resizeable = true;
    protected boolean designMode = true;
    private Stroke dashedStroke = new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{3.0f, 5.0f}, 0.0f);
    protected Point lassoStart = null;
    protected Point lassoLast = null;
    protected Color focusedHighlightColor = SystemColor.textHighlight;
    protected Color unfocusedHighlightColor = null;
    public final Action SELECT_ALL_ACTION = new SimpleAction("Select all"){

        public void perform() {
            Zoo.this.selectAll();
        }
    };
    public final Action DESELECT_ALL_ACTION = new SimpleAction("Deselect all"){

        public void perform() {
            Zoo.this.deselectAll();
        }
    };
    public final Action GROUP_SELECTED_COMPONENTS_ACTION = new SimpleAction("Group selected components"){

        public void perform() {
            Zoo.this.groupSelection();
        }
    };
    public final Action UNGROUP_SELECTED_COMPONENT_ACTION = new SimpleAction("Ungroup selected component"){

        public void perform() {
            Component component = Zoo.this.getSelectedComponent();
            if (component instanceof ZooGroup) {
                Zoo.this.ungroup((ZooGroup)component);
            }
        }
    };
    public final Action UNGROUP_SELECTED_COMPONENTS_ACTION = new SimpleAction("Ungroup selected components"){

        public void perform() {
            Zoo.this.ungroupSelection();
        }
    };
    public final Action TOGGLE_DESIGN_MODE_ACTION = new SimpleAction("Toggle design mode"){

        public void perform() {
            Zoo.this.setInDesignMode(!Zoo.this.isInDesignMode());
        }
    };
    public final Action SET_DESIGN_MODE_ON_ACTION = new SimpleAction("Set design mode on"){

        public void perform() {
            Zoo.this.setInDesignMode(true);
        }
    };
    public final Action SET_DESIGN_MODE_OFF_ACTION = new SimpleAction("Set design mode off"){

        public void perform() {
            Zoo.this.setInDesignMode(false);
        }
    };
    public final Action SEND_TO_BACK_ACTION = new SimpleAction("Send to back"){

        public void perform() {
            Zoo.this.sendToBack(Zoo.this.getSelectedComponent());
        }
    };
    public final Action BRING_TO_FRONT_ACTION = new SimpleAction("Bring to front"){

        public void perform() {
            Zoo.this.bringToFront(Zoo.this.getSelectedComponent());
        }
    };
    public final Action MOVE_UP_ACTION = new SimpleAction("Move up"){

        public void perform() {
            Zoo.this.moveUp(Zoo.this.getSelectedComponent());
        }
    };
    public final Action MOVE_DOWN_ACTION = new SimpleAction("Move down"){

        public void perform() {
            Zoo.this.moveDown(Zoo.this.getSelectedComponent());
        }
    };

    public Zoo() {
        this(true);
    }

    public Zoo(boolean bl) {
        this.setRestrictingBounds(bl);
        this.installSelectionModel();
        this.installMouseAdapter();
        this.installFocusAdapter();
        this.updateSelectionActions();
        this.updateDesignModeActions();
    }

    public Component addChildItem(Component component) {
        return this.addChildItemImpl(component, 0);
    }

    public Component addChildItem(Component component, int n) {
        return this.addChildItemImpl(component, n);
    }

    public Component[] getItems() {
        Vector<Component> vector = new Vector<Component>();
        Component component = null;
        ZooGroup zooGroup = null;
        Component[] componentArray = null;
        int n = 0;
        while (n < this.getComponentCount()) {
            component = this.getComponent(n);
            if (component instanceof ZooGroup) {
                zooGroup = (ZooGroup)component;
                componentArray = zooGroup.getItems();
                int n2 = 0;
                while (n2 < componentArray.length) {
                    vector.add(componentArray[n2]);
                    ++n2;
                }
            } else if (!(component instanceof Laminate)) {
                vector.add(component);
            }
            ++n;
        }
        return vector.toArray(new Component[0]);
    }

    public Component getChildItem(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Zoo z-order is invalid: " + n);
        }
        int n2 = n;
        Component component = null;
        int n3 = 0;
        while (n3 < this.getComponentCount()) {
            component = this.getComponent(n3);
            if (!(component instanceof Laminate)) {
                if (n2 == 0) {
                    return this.getComponent(n3);
                }
                --n2;
            }
            ++n3;
        }
        throw new ArrayIndexOutOfBoundsException("Zoo z-order is invalid: " + n);
    }

    public Component[] getChildItems() {
        Vector<Component> vector = new Vector<Component>();
        int n = 0;
        while (n < this.getComponentCount()) {
            if (!(this.getComponent(n) instanceof Laminate)) {
                vector.add(this.getComponent(n));
            }
            ++n;
        }
        return vector.toArray(new Component[0]);
    }

    public int getChildItemCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.getComponentCount()) {
            if (!(this.getComponent(n2) instanceof Laminate)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public Component removeChildItem(Component component) {
        return this.removeChildItemImpl(component);
    }

    public Component removeChildItem(int n) {
        return this.removeChildItemImpl(this.getChildItem(n));
    }

    public void removeAllItems() {
        super.removeAllItems();
        this.deselectAll();
        this.updateSelectionActions();
    }

    public int moveToZOrder(Component component, int n) {
        int n2 = this.inverseGetChildItem(component);
        if (n2 == -1) {
            return -1;
        }
        if (n2 == n) {
            return n2;
        }
        boolean bl = this.selectionModel.isSelectedIndex(n2);
        n = super.moveToZOrder(component, n);
        if (bl) {
            this.addToSelection(component);
        }
        this.updateSelection();
        return n;
    }

    public ZooGroup group(Component[] componentArray) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n2 < componentArray.length) {
            n = this.inverseGetChildItem(componentArray[n2]);
            if (n > -1) {
                bl |= this.selectionModel.isSelectedIndex(n);
            }
            if (bl) break;
            ++n2;
        }
        ZooGroup zooGroup = super.group(componentArray);
        if (zooGroup == null) {
            return null;
        }
        if (bl) {
            this.addToSelection(zooGroup);
        }
        this.updateSelectionActions();
        return zooGroup;
    }

    public Component[] ungroup(ZooGroup zooGroup) {
        int n = this.inverseGetChildItem(zooGroup);
        if (n == -1) {
            return new Component[0];
        }
        boolean bl = this.selectionModel.isSelectedIndex(n);
        Component[] componentArray = super.ungroup(zooGroup);
        if (bl) {
            int n2 = 0;
            while (n2 < componentArray.length) {
                this.addToSelection(componentArray[n2]);
                ++n2;
            }
        }
        this.updateSelection();
        this.updateSelectionActions();
        return componentArray;
    }

    public void selectAll() {
        if (this.selectionModel.isSelectionEmpty() && this.getChildItemCount() == 0) {
            return;
        }
        if (this.selectionModel.getMinSelectionIndex() == 0 && this.selectionModel.getMaxSelectionIndex() == this.getChildItemCount() - 1) {
            return;
        }
        if (!this.hasFocus()) {
            this.requestFocus();
        }
        this.selectionModel.setSelectionInterval(0, this.getChildItemCount() - 1);
        this.updateSelection();
        this.updateSelectionActions();
    }

    public void deselectAll() {
        if (this.selectionModel.isSelectionEmpty() && this.getChildItemCount() == 0) {
            return;
        }
        if (this.selectionModel.isSelectionEmpty()) {
            return;
        }
        if (!this.hasFocus()) {
            this.requestFocus();
        }
        this.selectionModel.clearSelection();
        this.updateSelection();
        this.updateSelectionActions();
        this.repaint();
    }

    public void addToSelection(Component component) {
        int n = this.inverseGetChildItem(component);
        if (n == -1) {
            return;
        }
        if (!this.hasFocus()) {
            this.requestFocus();
        }
        if (!this.selectionModel.isSelectedIndex(n)) {
            this.selectionModel.addSelectionInterval(n, n);
            Laminate laminate = this.getLaminateFor(component);
            if (laminate != null) {
                laminate.setSelected(true);
            }
            this.updateSelectionActions();
            this.repaint();
        }
    }

    public void removeFromSelection(Component component) {
        int n = this.inverseGetChildItem(component);
        if (n == -1) {
            return;
        }
        if (!this.hasFocus()) {
            this.requestFocus();
        }
        if (this.selectionModel.isSelectedIndex(n)) {
            this.selectionModel.removeSelectionInterval(n, n);
            Laminate laminate = this.getLaminateFor(component);
            if (laminate != null) {
                laminate.setSelected(false);
            }
            this.updateSelectionActions();
            this.repaint();
        }
    }

    public void selectOnly(Component component) {
        int n = this.inverseGetChildItem(component);
        if (n == -1) {
            return;
        }
        this.selectionModel.setSelectionInterval(n, n);
        this.updateSelection();
        this.updateSelectionActions();
    }

    /*
     * Unable to fully structure code
     */
    public void setSelectedComponents(Component[] var1_1) {
        if (var1_1 == null) {
            return;
        }
        var3_2 = new boolean[this.getChildItemCount()];
        var4_3 = 0;
        while (var4_3 < var1_1.length) {
            var2_4 = this.inverseGetChildItem(var1_1[var4_3]);
            if (var2_4 != -1) {
                var3_2[var2_4] = true;
            }
            ++var4_3;
        }
        var5_5 = 0;
        while (var5_5 < var3_2.length) {
            if (this.selectionModel.isSelectedIndex(var5_5) != var3_2[var5_5]) break;
            ++var5_5;
        }
        if (var5_5 == var3_2.length) {
            return;
        }
        this.selectionModel.clearSelection();
        var6_6 = 0;
        var7_7 = 0;
        while (var6_6 < var3_2.length && !var3_2[var6_6]) {
            ++var6_6;
        }
        var7_7 = var6_6;
        ** GOTO lbl36
        {
            ++var7_7;
            do {
                if (var7_7 < var3_2.length && var3_2[var7_7]) continue block3;
                var7_7 = var7_7 == var6_6 ? var6_6 + 1 : var7_7;
                this.selectionModel.addSelectionInterval(var6_6, var7_7 - 1);
                var6_6 = var7_7;
                while (var6_6 < var3_2.length && !var3_2[var6_6]) {
                    ++var6_6;
                }
                var7_7 = var6_6;
lbl36:
                // 2 sources

            } while (var6_6 < var3_2.length);
        }
        this.updateSelection();
        this.updateSelectionActions();
    }

    public Component getSelectedComponent() {
        if (this.selectionModel.isSelectionEmpty()) {
            return null;
        }
        return this.getChildItem(this.selectionModel.getMinSelectionIndex());
    }

    public Component getSelectedComponent(int n) {
        if (this.selectionModel.isSelectionEmpty()) {
            return null;
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index into selected components invalid: " + n);
        }
        int n2 = n;
        int n3 = this.selectionModel.getMinSelectionIndex();
        while (n3 <= this.selectionModel.getMaxSelectionIndex()) {
            if (this.selectionModel.isSelectedIndex(n3)) {
                if (n2 == 0) {
                    return this.getChildItem(n3);
                }
                --n2;
            }
            ++n3;
        }
        throw new ArrayIndexOutOfBoundsException("Index into selected components invalid: " + n);
    }

    public Component[] getSelectedComponents() {
        Vector<Component> vector = new Vector<Component>();
        Component[] componentArray = this.getChildItems();
        int n = this.selectionModel.getMinSelectionIndex();
        while (n <= this.selectionModel.getMaxSelectionIndex()) {
            if (this.selectionModel.isSelectedIndex(n)) {
                vector.add(componentArray[n]);
            }
            ++n;
        }
        return vector.toArray(new Component[0]);
    }

    public int getSelectedComponentCount() {
        if (this.isSelectionEmpty()) {
            return 0;
        }
        int n = 0;
        int n2 = this.selectionModel.getMinSelectionIndex();
        while (n2 <= this.selectionModel.getMaxSelectionIndex()) {
            if (this.selectionModel.isSelectedIndex(n2)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public boolean isSelectionEmpty() {
        return this.selectionModel.isSelectionEmpty();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public ZooGroup groupSelection() {
        Component[] componentArray = this.getSelectedComponents();
        if (componentArray.length > 1) {
            return this.group(componentArray);
        }
        return null;
    }

    public void ungroupSelection() {
        Component[] componentArray = this.getSelectedComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof ZooGroup) {
                this.ungroup((ZooGroup)componentArray[n]);
            }
            ++n;
        }
    }

    public void setInDesignMode(boolean bl) {
        this.designMode = bl;
        if (this.designMode) {
            this.mouseAdapter.addAsListenerTo(this);
        } else {
            this.mouseAdapter.removeAsListenerTo(this);
        }
        Laminate laminate = null;
        Component[] componentArray = this.getChildItems();
        int n = 0;
        while (n < componentArray.length) {
            laminate = this.getLaminateFor(componentArray[n]);
            if (laminate != null) {
                laminate.setActivated(this.designMode);
                if (!this.designMode) {
                    laminate.setSelected(false);
                }
            }
            ++n;
        }
        this.updateDesignModeActions();
        if (this.designMode) {
            this.updateSelection();
        }
        this.repaint();
    }

    public boolean isInDesignMode() {
        return this.designMode;
    }

    public void setRestrictingBounds(boolean bl) {
        this.restrictingBounds = bl;
    }

    public boolean isRestrictingBounds() {
        return this.restrictingBounds;
    }

    public void setAllowsMove(boolean bl) {
        this.moveable = bl;
    }

    public boolean allowsMove() {
        return this.moveable;
    }

    public void setAllowsResize(boolean bl) {
        this.resizeable = bl;
    }

    public boolean allowsResize() {
        return this.resizeable;
    }

    public void setFocusedHighlightColor(Color color) {
        if (color == null) {
            return;
        }
        this.focusedHighlightColor = color;
    }

    public Color getFocusedHighlightColor() {
        return this.focusedHighlightColor;
    }

    public void setUnfocusedHighlightColor(Color color) {
        if (color == null) {
            return;
        }
        this.unfocusedHighlightColor = color;
    }

    public Color getUnfocusedHighlightColor() {
        if (this.unfocusedHighlightColor == null) {
            return this.computeUnfocusedHighlightColor(this.getFocusedHighlightColor());
        }
        return this.unfocusedHighlightColor;
    }

    public Laminate getLaminateFor(Component component) {
        Object v = this.laminateTable.get(component);
        if (v instanceof Laminate) {
            return (Laminate)v;
        }
        return null;
    }

    public boolean isFocusTraversable() {
        return this.isInDesignMode();
    }

    public boolean isManagingFocus() {
        return this.isInDesignMode();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.hasFocus() && this.isInDesignMode()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = this.getLassoBounds();
            if (rectangle != null) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(this.dashedStroke);
                graphics2D.draw(rectangle);
                graphics2D.setStroke(stroke);
            } else if (this.isSelectionEmpty()) {
                Insets insets = this.getInsets();
                graphics2D.setColor(SystemColor.textHighlight);
                graphics2D.drawRect(insets.left, insets.top, this.getWidth() - 1 - insets.left - insets.right, this.getHeight() - 1 - insets.top - insets.bottom);
            }
        }
    }

    protected Laminate createLaminateFor(Component component) {
        return new Laminate(component, this.isInDesignMode());
    }

    protected void installMouseAdapter() {
        this.mouseAdapter = new MouseActionAdapter(this);
        this.mouseAdapter.addMousePressedAction(new MouseAction(){

            public void mouseActionPerformed(MouseEvent mouseEvent) {
                Zoo.this.startLasso(mouseEvent);
            }
        });
        this.mouseAdapter.addMouseDraggedAction(new MouseAction(){

            public void mouseActionPerformed(MouseEvent mouseEvent) {
                Zoo.this.resizeLasso(mouseEvent);
            }
        });
        this.mouseAdapter.addMouseReleasedAction(new MouseAction(){

            public void mouseActionPerformed(MouseEvent mouseEvent) {
                Zoo.this.endLasso(mouseEvent);
            }
        });
    }

    protected void installSelectionModel() {
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(2);
    }

    protected void installFocusAdapter() {
        FocusActionAdapter focusActionAdapter = new FocusActionAdapter();
        this.addFocusListener(focusActionAdapter);
        SimpleAction simpleAction = new SimpleAction(){

            public void perform() {
                Zoo.this.repaint();
            }
        };
        focusActionAdapter.addFocusGainedAction(simpleAction);
        focusActionAdapter.addFocusLostAction(simpleAction);
    }

    protected void updateSelection() {
        Component[] componentArray = this.getChildItems();
        int n = 0;
        while (n < componentArray.length) {
            Laminate laminate = this.getLaminateFor(componentArray[n]);
            if (laminate != null) {
                laminate.setSelected(this.selectionModel.isSelectedIndex(n));
            }
            ++n;
        }
        this.repaint();
    }

    protected Rectangle getLassoBounds() {
        if (this.lassoStart == null) {
            return null;
        }
        int n = Math.min(this.lassoStart.x, this.lassoLast.x);
        int n2 = Math.min(this.lassoStart.y, this.lassoLast.y);
        int n3 = Math.max(this.lassoStart.x, this.lassoLast.x);
        int n4 = Math.max(this.lassoStart.y, this.lassoLast.y);
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    protected void startLasso(MouseEvent mouseEvent) {
        this.lassoLast = this.lassoStart = new Point(mouseEvent.getX(), mouseEvent.getY());
        if (!mouseEvent.isShiftDown()) {
            this.deselectAll();
        }
    }

    protected void resizeLasso(MouseEvent mouseEvent) {
        this.lassoLast = new Point(mouseEvent.getX(), mouseEvent.getY());
        Rectangle rectangle = this.getLassoBounds();
        Component[] componentArray = this.getChildItems();
        int n = 0;
        while (n < componentArray.length) {
            if (rectangle.contains(componentArray[n].getBounds())) {
                this.addToSelection(componentArray[n]);
            } else if (!mouseEvent.isShiftDown()) {
                this.removeFromSelection(componentArray[n]);
            }
            ++n;
        }
        this.repaint();
    }

    protected void endLasso(MouseEvent mouseEvent) {
        this.lassoStart = null;
        this.lassoLast = null;
        this.repaint();
    }

    protected void updateSelectionActions() {
        this.SELECT_ALL_ACTION.setEnabled(this.getSelectedComponentCount() != this.getChildItemCount());
        this.DESELECT_ALL_ACTION.setEnabled(!this.isSelectionEmpty());
        Component[] componentArray = this.getSelectedComponents();
        Component component = this.getSelectedComponent();
        this.GROUP_SELECTED_COMPONENTS_ACTION.setEnabled(componentArray.length > 1);
        this.UNGROUP_SELECTED_COMPONENT_ACTION.setEnabled(component instanceof ZooGroup);
        int n = this.inverseGetChildItem(component);
        this.SEND_TO_BACK_ACTION.setEnabled(componentArray.length == 1 && n < this.getChildItemCount() - 1 && n != -1);
        this.BRING_TO_FRONT_ACTION.setEnabled(componentArray.length == 1 && n > 0);
        this.MOVE_UP_ACTION.setEnabled(componentArray.length == 1 && n > 0);
        this.MOVE_DOWN_ACTION.setEnabled(componentArray.length == 1 && n < this.getChildItemCount() - 1 && n != -1);
        if (componentArray.length < 1) {
            this.UNGROUP_SELECTED_COMPONENTS_ACTION.setEnabled(false);
            return;
        }
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (!(componentArray[n2] instanceof ZooGroup)) {
                this.UNGROUP_SELECTED_COMPONENTS_ACTION.setEnabled(false);
                return;
            }
            ++n2;
        }
        this.UNGROUP_SELECTED_COMPONENTS_ACTION.setEnabled(true);
    }

    protected void updateDesignModeActions() {
        this.SET_DESIGN_MODE_ON_ACTION.setEnabled(!this.isInDesignMode());
        this.SET_DESIGN_MODE_OFF_ACTION.setEnabled(this.isInDesignMode());
    }

    protected Color computeUnfocusedHighlightColor(Color color) {
        if (color == null) {
            return Color.black;
        }
        int n = Math.max(color.getRed(), Math.max(color.getBlue(), color.getGreen()));
        if ((double)n / 255.0 < 0.1) {
            return color.brighter();
        }
        return color.darker();
    }

    private Component addChildItemImpl(Component component, int n) {
        if (component == null) {
            return null;
        }
        if (n == -1) {
            n = this.getChildItemCount();
        }
        if (n < 0 || n > this.getChildItemCount()) {
            throw new ArrayIndexOutOfBoundsException("Zoo z-order invalid: " + n);
        }
        if (component.getHeight() == 0 && component.getWidth() == 0) {
            component.setSize(component.getPreferredSize());
        }
        Laminate laminate = this.createLaminateFor(component);
        this.laminateTable.put(component, laminate);
        int n2 = this.zOrderToIndex(n);
        this.add((Component)laminate, n2);
        this.add(component, n2 + 1);
        this.selectionModel.insertIndexInterval(n, 1, true);
        this.selectionModel.removeSelectionInterval(n, n);
        this.updateSelection();
        this.updateSelectionActions();
        return component;
    }

    private Component removeChildItemImpl(Component component) {
        Component[] componentArray = this.getChildItems();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == component) {
                this.removeComponentImpl(component, n);
                this.updateSelection();
                return component;
            }
            ++n;
        }
        return null;
    }

    private void removeComponentImpl(Component component, int n) {
        if (component instanceof Laminate) {
            return;
        }
        if (n == -1) {
            n = this.inverseGetChildItem(component);
        }
        if (n == -1) {
            return;
        }
        Laminate laminate = this.getLaminateFor(component);
        component.removeComponentListener(laminate);
        laminate.setTarget(null);
        this.remove(laminate);
        this.remove(component);
        this.selectionModel.removeIndexInterval(n, n);
        this.updateSelectionActions();
    }

    private int zOrderToIndex(int n) {
        int n2 = 0;
        while (n2 < this.getComponentCount()) {
            if (n == 0) {
                return n2;
            }
            if (!(this.getComponent(n2) instanceof Laminate)) {
                --n;
            }
            ++n2;
        }
        return this.getComponentCount();
    }
}

