/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.util.DimensionUtilities;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;

public class AlignedLayout
implements LayoutManager2,
JPTConstants {
    protected Component c = null;
    protected int alignment = 6;

    public AlignedLayout() {
    }

    public AlignedLayout(int n) {
        this.setAlignment(n);
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, null);
    }

    public void addLayoutComponent(Component component, Object object) {
        this.c = component;
    }

    public void removeLayoutComponent(Component component) {
        if (this.c == component) {
            this.c = null;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        if (this.c == null) {
            return DimensionUtilities.createMinimumDimension();
        }
        return DimensionUtilities.expand(this.c.getMinimumSize(), container.getInsets());
    }

    public Dimension preferredLayoutSize(Container container) {
        if (this.c == null) {
            return DimensionUtilities.createMinimumDimension();
        }
        return DimensionUtilities.expand(this.c.getPreferredSize(), container.getInsets());
    }

    public Dimension maximumLayoutSize(Container container) {
        if (this.c == null) {
            return DimensionUtilities.createMaximumDimension();
        }
        return DimensionUtilities.expand(this.c.getMaximumSize(), container.getInsets());
    }

    public void layoutContainer(Container container) {
        if (this.c == null) {
            return;
        }
        Insets insets = container.getInsets();
        Dimension dimension = DimensionUtilities.shrink(container.getSize(), insets);
        Dimension dimension2 = DimensionUtilities.min(this.c.getPreferredSize(), dimension);
        Point point = this.applyAlignment(dimension2, dimension, new Point(insets.left, insets.top));
        this.c.setBounds(point.x, point.y, dimension2.width, dimension2.height);
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void setAlignment(int n) {
        switch (n) {
            case -1: {
                n = 8;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.alignment = n;
            }
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    protected Point applyAlignment(Dimension dimension, Dimension dimension2, Point point) {
        Point point2 = new Point();
        int n = dimension2.width - dimension.width;
        int n2 = dimension2.height - dimension.height;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = point.x;
        int n4 = point.x + n / 2;
        int n5 = point.x + n;
        int n6 = point.y;
        int n7 = point.y + n2 / 2;
        int n8 = point.y + n2;
        switch (this.getAlignment()) {
            case 2: {
                point2.setLocation(n5, n6);
                break;
            }
            case 3: {
                point2.setLocation(n5, n7);
                break;
            }
            case 4: {
                point2.setLocation(n5, n8);
                break;
            }
            case 1: {
                point2.setLocation(n4, n6);
                break;
            }
            case 0: {
                point2.setLocation(n4, n7);
                break;
            }
            case 5: {
                point2.setLocation(n4, n8);
                break;
            }
            case 8: {
                point2.setLocation(n3, n6);
                break;
            }
            case 7: {
                point2.setLocation(n3, n7);
                break;
            }
            default: {
                point2.setLocation(n3, n8);
            }
        }
        return point2;
    }
}

