/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XByte;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.XObject;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class XDouble
extends XNumber {
    private double value = 0.0;

    public XDouble() {
    }

    public XDouble(double d) {
        this.value = d;
    }

    public XDouble(String string) throws ParseException {
        this.fromStringData(string);
    }

    public void fromStringData(String string) throws ParseException {
        double d = this.value;
        Parser parser = ParserUtilities.getDefaultParser();
        Object object = parser.parse(string);
        if (!(object instanceof XNumber)) {
            throw new ParseException("Expected numeric value.", string.length());
        }
        XNumber xNumber = (XNumber)object;
        this.value = xNumber.doubleValue();
        this.changeAdapter.firePropertyChange("value", new Double(d), string);
    }

    public String toStringData() {
        return this.value + "";
    }

    public byte byteValue() {
        if (this.getValue() > 127.0 || this.getValue() < -128.0) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue();
    }

    public short shortValue() {
        if (this.getValue() > 32767.0 || this.getValue() < -32768.0) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue();
    }

    public int intValue() {
        if (this.getValue() > 2.147483647E9 || this.getValue() < -2.147483648E9) {
            throw new NumberFormatException("Number beyond precision of an int.");
        }
        return (int)this.getValue();
    }

    public long longValue() {
        if (this.getValue() > 9.223372036854776E18 || this.getValue() < -9.223372036854776E18) {
            throw new NumberFormatException("Number beyond precision of a long.");
        }
        return (long)this.getValue();
    }

    public float floatValue() {
        if (this.getValue() > 3.4028234663852886E38 || this.getValue() < -3.4028234663852886E38) {
            throw new NumberFormatException("Number beyond precision of a float.");
        }
        return (float)this.getValue();
    }

    public double doubleValue() {
        return this.getValue();
    }

    public boolean equals(Object object) {
        if (object instanceof XByte) {
            return this.getValue() == ((XDouble)object).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Double(this.getValue()).hashCode();
    }

    public String toString() {
        return this.value + "";
    }

    public void setValue(double d) {
        double d2 = this.value;
        this.value = d;
        if (this.getValue() != d2) {
            this.changeAdapter.firePropertyChange("value", new Double(d2), new Double(this.getValue()));
        }
    }

    public double getValue() {
        return this.value;
    }

    public static double parseDouble(String string) throws NumberFormatException {
        try {
            return new XDouble((String)string).value;
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(XObject.formatErrorMessage(parseException, string));
        }
    }

    public static double[] toPrimitiveArray(XDouble[] xDoubleArray) {
        if (xDoubleArray == null) {
            return null;
        }
        double[] dArray = new double[xDoubleArray.length];
        int n = 0;
        while (n < dArray.length) {
            if (xDoubleArray[n] != null) {
                dArray[n] = xDoubleArray[n].getValue();
            }
            ++n;
        }
        return dArray;
    }

    public static XDouble[] toXArray(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        XDouble[] xDoubleArray = new XDouble[dArray.length];
        int n = 0;
        while (n < xDoubleArray.length) {
            xDoubleArray[n] = new XDouble(dArray[n]);
            ++n;
        }
        return xDoubleArray;
    }
}

