/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class ShapeCapsule
extends JComponent {
    protected Shape shape = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    protected Paint paint = Color.black;

    public ShapeCapsule(Shape shape) {
        this(shape, null);
    }

    public ShapeCapsule(Shape shape, Paint paint) {
        this.setPaint(paint);
        this.setShape(shape);
    }

    public void setShape(Shape shape) {
        if (shape == null) {
            return;
        }
        this.shape = new GeneralPath(shape);
        Rectangle rectangle = this.shape.getBounds();
        Insets insets = this.getInsets();
        super.setBounds(rectangle.x - insets.left, rectangle.y - insets.top, rectangle.width + insets.left + insets.right, rectangle.height + insets.top + insets.bottom);
        this.setPreferredSize(new Dimension(rectangle.width, rectangle.height));
        this.repaint();
    }

    public Shape getShape() {
        return new GeneralPath(this.shape);
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setLocation(Point point) {
        this.setBounds(point.x, point.y, this.getWidth(), this.getHeight());
    }

    public void setLocation(int n, int n2) {
        this.setBounds(n, n2, this.getWidth(), this.getHeight());
    }

    public void setSize(Dimension dimension) {
        this.setBoundsImpl(this.getX(), this.getY(), dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        this.setBoundsImpl(this.getX(), this.getY(), n, n2);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBoundsImpl(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.setBoundsImpl(n, n2, n3, n4);
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath generalPath = new GeneralPath(this.getShape());
        Rectangle rectangle = generalPath.getBounds();
        Insets insets = this.getInsets();
        generalPath.transform(AffineTransform.getTranslateInstance(0 - (rectangle.x + insets.left), 0 - (rectangle.y + insets.top)));
        graphics2D.setPaint(this.getPaint());
        graphics2D.fill(generalPath);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    private void setBoundsImpl(int n, int n2, int n3, int n4) {
        GeneralPath generalPath = new GeneralPath(this.shape);
        Rectangle rectangle = generalPath.getBounds();
        generalPath.transform(AffineTransform.getTranslateInstance(-rectangle.x, -rectangle.y));
        generalPath.transform(AffineTransform.getScaleInstance((double)n3 / (double)rectangle.width, (double)n4 / (double)rectangle.height));
        generalPath.transform(AffineTransform.getTranslateInstance(n, n2));
        this.setShape(generalPath);
    }
}

