/* 
TestSuite.java  26 February 2003 */


import java.awt.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.math.*;

public class TestSuite extends JPFalt 
{
    public static void main(String[] args) { new TestSuite(); }
    
    ///////////////////////////////////////////////////////////
    // Place your actual methods here.                       //
    ///////////////////////////////////////////////////////////
	 	
	/*----------------------------------------------------------------------- 
	 Test incomming socket and iterator for input of series of lines
	------------------------------------------------------------------------- */
	public void TestSocketServer(){
	
		String inputLine;
		
		AsciiSocket as=new AsciiSocket();
		
		println("Waiting for an incoming connection on port " 
		        +AsciiSocket.DEFAULT_PORT+"...");
		
		if(as.listenOn()){
			println("Connected!!!");
			as.writeLine("Hi im an example echo socket... " + 
			             "I'll repeat every line you say");
			
			for(IRange it=as.lineIRange(); 
			    it.hasMore(); 
			    it.next()){
			    
				inputLine = (String)it.current();
				println(it.current());
				as.writeLine("You typed: "+it.current());
			}
			
			println("Disconnected");
		}
		
		else{
			println("Could not bind ServerSocket");
		}
	}
	

	/*----------------------------------------------------------------------- 
	 Test incomming socket and iterator for input of series of lines
	------------------------------------------------------------------------- */
	public void TestSocketClient(){
	
		String inputLine;
		
		AsciiSocket as=new AsciiSocket();
		
		println("Trying to connecto to localhost:"+AsciiSocket.DEFAULT_PORT+"...");
		String host = console.in.demandString("Connect to:");

		if(as.connectTo(host)){
			println("Connected!!!");
			as.writeLine("Hi im an example echo socket... " + 
			             "I'll repeat every line you say");
			
			as.writeLine("i just connected to you!!!");
			as.writeLine("this is a sample line i could sent to you");
			as.writeLine("im a test outgoing connection");
			as.writeLine("more sample stuff");

			for(IRange it=as.lineIRange(); 
			    it.hasMore(); 
			    it.next()){			    
				println("Recived line from socket: "+ it.current());
			}
			
			println("Disconnected");
		}
		
		else{
			println("Could not bind ServerSocket");
		}
	}
	
	/* simplified server socket connection */
	public void TestSimpleSocketEcho(){
	
		String inputLine;
		
		AsciiSocket as=new AsciiSocket();
		String hostid = console.in.demandString("Your id:");
		
		if(as.listenOn()){
			as.writeLine(hostid + " ready");
			
			for(IRange it=as.lineIRange(); 
			    it.hasMore(); 
			    it.next()){
			    
				inputLine = (String)it.current();
				println(inputLine);
				as.writeLine("You typed: "+it.current());
			}
			
			println("Disconnected");
		}
		
		else{
			println("Could not bind ServerSocket");
		}
	}
	

	/*----------------------------------------------------------------------- 
	 Test socket iterator for input of series of lines
	------------------------------------------------------------------------- */
    void TestSocketRange(){
    
		String inputLine;
		String host = console.in.demandString("Name to connect to:");
		
		int n = 5;
		        
        for (IRange it = new SocketRange(host);
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            
            println("You typed: " + inputLine);
            n = n-1;
            if (n == 0)
            	((SocketRange)it).disconnect();
        }
        println("Done with socket range.");        
    }
        
	/*----------------------------------------------------------------------- 
	 Test console iterator for input of series of lines
	------------------------------------------------------------------------- */
    void TestInConsoleRangeEcho(){
    
		String inputLine;
		        
        for (IRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            
            println("You typed: " + inputLine);
        }        
    }
        
	/*----------------------------------------------------------------------- 
	 Test console iterator for input of series of lines, with user responses
	-----------------------------------------------------------------------*/
    void TestInConsoleRangeReply(){
    
		String inputLine;
		String response;
		        
        for (IRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            println("Received from input stream: " + inputLine);
            
            response = console.in.demandString("Please, reply: ");
            println("Posted to output stream: " + response);
        }        
    }
        
	/*----------------------------------------------------------------------- 
	 Test console iterator for input of series of numbers
	-----------------------------------------------------------------------*/
    void TestInConsoleRangeIntegers(){
    
		String inputLine;
		int number;
		        
        for (IRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            number = (new Integer(inputLine)).intValue();
            
            println("You typed: " + 2 * number);
            
        }        
    }

	/*----------------------------------------------------------------------- 
	 Test console iterator with NumberGame
	-----------------------------------------------------------------------*/
    void TestNumberGame(){
    
		NumberGame ng = new NumberGame(0, 100);
		
		String inputLine;
		int number;
		        
        for (IRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            number = (new Integer(inputLine)).intValue();
            
            println(ng.replyToGuess(number));
        }        
    }
    
	/*----------------------------------------------------------------------- 
	 Test console iterator with Eliza
	-----------------------------------------------------------------------*/
    void TestEliza(){
    
		Eliza liz = new Eliza();
		
		String inputLine;
		        
        for (IRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            
            println(liz.selectAnswer(inputLine));
        }        
    }
    
}

