/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern:
        iterator for console input of a list of balloons 
*/

import edu.neu.ccs.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.util.*;

import java.io.*;
import java.awt.*;

class InConsoleRange implements IRange, ConsoleAware {

    /*-------------------------------------------------------- 
     Member data
     *------------------------------------------------------*/
    /* a person object to hold values */
    protected String s;
    
    /* determines whether the input has been closed */
    protected boolean closed = true;
    
    /* determines whether new baloon data has been submitted */
    protected boolean submitted = false;
    
    
       
    /*-------------------------------------------------------- 
     Constructor
     *------------------------------------------------------*/
    InConsoleRange() { 
    
        /* currently not closed */
        closed = false;   
        
        /* extract values for the first balloon */
        next();
    }
        
    /*--------------------------------------------------------
     Methods to implement the IRange interface
     *------------------------------------------------------*/

    public void next() {
        submitted = false;
        
        /* wait till user types in the input or ends input */
        read();
        submitted = true; 
    }

    public Object current() {
        if ((submitted) && (!closed)){
            return s;
        }
        else{
            return null;
        }
    }
    
    public boolean hasMore() {
        return ((submitted) && (!closed)); 
    }
    
    /*--------------------------------------------------------------
     Methods and helpers to read and close the input
     *------------------------------------------------------------*/

    /* read one line from the console */
    public void read(){  
          
        try{
			s = requestString("Type in a line: ");
			submitted = true;
        }
        catch(IOException e){
            console.out.println(e.getMessage());
        }
    }
    
    /* request one string from the console */
    public String requestString(String prompt) throws IOException{

		XString temp = new XString();;
        boolean more = console.in.reading(prompt, (Stringable)temp);
        if (more)
            return temp.getValue();
        else
            closed = true;
            throw(new IOException("End of input."));
    }
    
}
        
