/*
 * Decompiled with CFR 0.152.
 */
import edu.neu.ccs.Stringable;
import edu.neu.ccs.XString;
import edu.neu.ccs.console.ConsoleAware;
import java.io.IOException;

class InConsoleRange
implements IRange,
ConsoleAware {
    protected String s;
    protected boolean closed = false;
    protected boolean submitted = false;

    InConsoleRange() {
        this.next();
    }

    public void next() {
        this.submitted = false;
        this.read();
        this.submitted = true;
    }

    public Object current() {
        if (this.submitted && !this.closed) {
            return this.s;
        }
        return null;
    }

    public boolean hasMore() {
        return this.submitted && !this.closed;
    }

    public void read() {
        try {
            this.s = this.requestString("Type in a line: ");
            this.submitted = true;
        }
        catch (IOException e) {
            ConsoleAware.console.out.println(e.getMessage());
        }
    }

    public String requestString(String prompt) throws IOException {
        XString temp = new XString();
        boolean more = ConsoleAware.console.in.reading(prompt, (Stringable)temp);
        if (more) {
            return temp.getValue();
        }
        this.closed = true;
        throw new IOException("End of input.");
    }
}

