/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;

class AsciiSocket {
    Socket socket;
    boolean IN_USE = false;
    public static int DEFAULT_PORT = 1234;
    public static String NEW_LINE = "\n";
    InputStream in = null;
    OutputStream out = null;

    AsciiSocket(Socket s) {
        this.socket = s;
    }

    AsciiSocket() {
        this(new Socket());
    }

    public boolean connectTo(String host, int port) {
        try {
            this.socket = new Socket(host, port);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean connectTo(String host) {
        return this.connectTo(host, DEFAULT_PORT);
    }

    public boolean listenOn(int port) {
        try {
            ServerSocket ss = new ServerSocket(port);
            boolean ret = this.listenOn(ss);
            ss.close();
            return ret;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean listenOn() {
        return this.listenOn(DEFAULT_PORT);
    }

    public boolean listenOn(ServerSocket s) {
        try {
            this.socket = s.accept();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void fillStreams() throws NotConnectedException {
        if (this.socket.isBound() && this.socket.isConnected() && !this.socket.isClosed()) {
            if (this.in == null || this.out == null) {
                try {
                    this.in = this.socket.getInputStream();
                    this.out = this.socket.getOutputStream();
                }
                catch (Exception exception) {
                    throw new NotConnectedException();
                }
            }
        } else {
            throw new NotConnectedException();
        }
    }

    public char readChar() throws NotConnectedException {
        int read;
        this.fillStreams();
        try {
            read = this.in.read();
        }
        catch (Exception exception) {
            throw new NotConnectedException();
        }
        if (read == -1) {
            throw new NotConnectedException();
        }
        return (char)read;
    }

    public String readTo(String to) throws NotConnectedException {
        try {
            while (this.IN_USE) {
                this.wait(100L);
            }
        }
        catch (Exception exception) {}
        this.IN_USE = true;
        String current = "";
        while (!current.endsWith(to)) {
            current = String.valueOf(current) + this.readChar();
        }
        this.IN_USE = false;
        return current;
    }

    public String readLine() throws NotConnectedException {
        String line = this.readTo(NEW_LINE);
        line = line.substring(0, line.lastIndexOf(NEW_LINE));
        return line;
    }

    public boolean write(String s) {
        try {
            this.fillStreams();
            this.out.write(s.getBytes());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean writeLine(String s) {
        return this.write(String.valueOf(s) + NEW_LINE);
    }

    Iterator lineIterator() {
        return new AsciiSocketIterator(this);
    }

    IRange lineIRange() {
        return new IteratorIRange(this.lineIterator());
    }

    class NotConnectedException
    extends Exception {
        NotConnectedException() {
        }
    }

    class AsciiSocketIterator
    implements Iterator {
        AsciiSocket as;
        Object nextItem = null;
        boolean hasNext;

        AsciiSocketIterator(AsciiSocket as) {
            this.as = as;
        }

        public boolean hasNext() {
            block2: {
                if (this.nextItem != null) break block2;
                try {
                    this.nextItem = this.as.readLine();
                    this.hasNext = true;
                }
                catch (NotConnectedException notConnectedException) {
                    this.nextItem = null;
                    this.hasNext = false;
                }
            }
            return this.hasNext;
        }

        public Object next() {
            Object ret = this.nextItem;
            this.nextItem = null;
            return ret;
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

