/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.util;

import java.awt.Dimension;
import java.awt.Insets;

public class DimensionUtilities {
    public static Dimension createDimension(int n, int n2) {
        n = Math.max(n, 0);
        n2 = Math.max(n2, 0);
        return new Dimension(n, n2);
    }

    public static Dimension createDimension(Dimension dimension) {
        return DimensionUtilities.createDimension((int)dimension.getWidth(), (int)dimension.getHeight());
    }

    public static Dimension createMinimumDimension() {
        return new Dimension(0, 0);
    }

    public static Dimension createMaximumDimension() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static Dimension min(Dimension dimension, Dimension dimension2) {
        int n = Math.min((int)dimension.getWidth(), (int)dimension2.getWidth());
        int n2 = Math.min((int)dimension.getHeight(), (int)dimension2.getHeight());
        return DimensionUtilities.createDimension(n, n2);
    }

    public static Dimension max(Dimension dimension, Dimension dimension2) {
        int n = Math.max((int)dimension.getWidth(), (int)dimension2.getWidth());
        int n2 = Math.max((int)dimension.getHeight(), (int)dimension2.getHeight());
        return DimensionUtilities.createDimension(n, n2);
    }

    public static Dimension expand(Dimension dimension, Insets insets) {
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        int n3 = insets.left + insets.right;
        int n4 = insets.top + insets.bottom;
        if (n3 > 0) {
            n = n < Integer.MAX_VALUE - n3 ? (n += n3) : Integer.MAX_VALUE;
        }
        if (n4 > 0) {
            n2 = n2 < Integer.MAX_VALUE - n4 ? (n2 += n4) : Integer.MAX_VALUE;
        }
        return DimensionUtilities.createDimension(n, n2);
    }

    public static Dimension shrink(Dimension dimension, Insets insets) {
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        int n3 = insets.left + insets.right;
        int n4 = insets.top + insets.bottom;
        if (n3 > 0) {
            n = n > n3 ? (n -= n3) : 0;
        }
        if (n4 > 0) {
            n2 = n2 > n4 ? (n2 -= n4) : 0;
        }
        return DimensionUtilities.createDimension(n, n2);
    }
}

