/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.parser;

import edu.neu.ccs.XBigDecimal;
import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XBoolean;
import edu.neu.ccs.XByte;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XFloat;
import edu.neu.ccs.XInt;
import edu.neu.ccs.XLong;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.XShort;
import edu.neu.ccs.parser.JPTParser;
import edu.neu.ccs.parser.Parser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.FieldPosition;

public class ParserUtilities {
    private static Parser parser = new JPTParser();

    public static Parser getDefaultParser() {
        return parser;
    }

    public static void setDefaultParser(Parser parser) {
        if (parser == null) {
            parser = new JPTParser();
        }
        ParserUtilities.parser = parser;
    }

    public static boolean isXNumber(Object object) {
        return object instanceof XNumber;
    }

    public static boolean isXIntegral(Object object) {
        return object instanceof XBigInteger || object instanceof XLong || object instanceof XInt || object instanceof XShort || object instanceof XByte;
    }

    public static boolean isXFloating(Object object) {
        return object instanceof XBigDecimal || object instanceof XDouble || object instanceof XFloat;
    }

    public static boolean isXBoolean(Object object) {
        return object instanceof XBoolean;
    }

    public static XLong toXLong(XNumber xNumber) {
        if (xNumber instanceof XLong) {
            return (XLong)xNumber;
        }
        return new XLong(xNumber.longValue());
    }

    public static XDouble toXDouble(XNumber xNumber) {
        if (xNumber instanceof XDouble) {
            return (XDouble)xNumber;
        }
        return new XDouble(xNumber.doubleValue());
    }

    public static XBigInteger toXBigInteger(XNumber xNumber) {
        if (xNumber instanceof XBigInteger) {
            return (XBigInteger)xNumber;
        }
        if (xNumber instanceof XBigDecimal) {
            XBigDecimal xBigDecimal = (XBigDecimal)xNumber;
            BigDecimal bigDecimal = xBigDecimal.getValue();
            return new XBigInteger(bigDecimal.toBigInteger());
        }
        String string = "0";
        if (ParserUtilities.isXIntegral(xNumber)) {
            string = xNumber.longValue() + "";
        } else {
            double d = xNumber.doubleValue();
            d = Math.rint(d);
            DecimalFormat decimalFormat = new DecimalFormat("#0");
            StringBuffer stringBuffer = new StringBuffer(1024);
            FieldPosition fieldPosition = new FieldPosition(0);
            stringBuffer = decimalFormat.format(d, stringBuffer, fieldPosition);
            string = stringBuffer.toString();
        }
        return new XBigInteger(new BigInteger(string));
    }

    public static XBigDecimal toXBigDecimal(XNumber xNumber) {
        if (xNumber instanceof XBigDecimal) {
            return (XBigDecimal)xNumber;
        }
        if (xNumber instanceof XBigInteger) {
            XBigInteger xBigInteger = (XBigInteger)xNumber;
            BigInteger bigInteger = xBigInteger.getValue();
            return new XBigDecimal(new BigDecimal(bigInteger));
        }
        if (ParserUtilities.isXIntegral(xNumber)) {
            String string = xNumber.longValue() + "";
            return new XBigDecimal(new BigDecimal(string));
        }
        double d = xNumber.doubleValue();
        return new XBigDecimal(new BigDecimal(d));
    }
}

