/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import edu.neu.ccs.XObject;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class XShort
extends XNumber {
    public short value = 0;

    public XShort() {
    }

    public XShort(short s) {
        this.value = s;
    }

    public XShort(String string) throws ParseException {
        this.fromStringData(string);
    }

    public void fromStringData(String string) throws ParseException {
        short s = this.value;
        Parser parser = ParserUtilities.getDefaultParser();
        Object object = parser.parse(string);
        if (!(object instanceof XNumber)) {
            throw new ParseException("Expected numeric value.", string.length());
        }
        XNumber xNumber = (XNumber)object;
        this.value = xNumber.shortValue();
        this.changeAdapter.firePropertyChange("value", new Short(s), string);
    }

    public String toStringData() {
        return this.value + "";
    }

    public byte byteValue() {
        if (this.getValue() > 127 || this.getValue() < -128) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue();
    }

    public short shortValue() {
        return this.getValue();
    }

    public int intValue() {
        return this.getValue();
    }

    public long longValue() {
        return this.getValue();
    }

    public float floatValue() {
        return this.getValue();
    }

    public double doubleValue() {
        return this.getValue();
    }

    public boolean equals(Object object) {
        if (object instanceof XShort) {
            return this.getValue() == ((XShort)object).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Short(this.getValue()).hashCode();
    }

    public String toString() {
        return this.value + "";
    }

    public void setValue(short s) {
        short s2 = this.value;
        this.value = s;
        if (this.getValue() != s2) {
            this.changeAdapter.firePropertyChange("value", new Short(s2), new Short(this.getValue()));
        }
    }

    public short getValue() {
        return this.value;
    }

    public static short parseShort(String string) throws NumberFormatException {
        try {
            return new XShort((String)string).value;
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(XObject.formatErrorMessage(parseException, string));
        }
    }

    public static short[] toPrimitiveArray(XShort[] xShortArray) {
        if (xShortArray == null) {
            return null;
        }
        short[] sArray = new short[xShortArray.length];
        int n = 0;
        while (n < sArray.length) {
            if (xShortArray[n] != null) {
                sArray[n] = xShortArray[n].getValue();
            }
            ++n;
        }
        return sArray;
    }

    public static XShort[] toXArray(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        XShort[] xShortArray = new XShort[sArray.length];
        int n = 0;
        while (n < xShortArray.length) {
            xShortArray[n] = new XShort(sArray[n]);
            ++n;
        }
        return xShortArray;
    }
}

