import java.lang.Exception;

public class Queue implements Queueable {
	
	// A node in the queue
	private class QueueNode
	{
		// Member Data
		Object first;
		QueueNode rest;
		
		// Full Constructor
		QueueNode( Object aFirst, QueueNode aRest )
		{
			first = aFirst;
			rest = aRest;
		}
	}
	
	// Member data - front and back of queue
	private QueueNode front;
	private QueueNode back;
	
	// Default constructor
	Queue()
	{
		front = null;
		back = null;
	}
	
	// See AQueue
	public void enq(Object add)
	{
		if( back!=null )
		{
			back.rest = new QueueNode( add, null );
			back = back.rest;
		}
		else
		{
			back = new QueueNode( add, null );
			front = back;
		}
	}
	
	// See AQueue
	public boolean isEmpty()
	{
		return front==null;
	}
	
	// See AQueue
	public Object peek()
	{
		return front;
	}
	
	// See AQueue
	public Object deq() throws Exception
	{
		QueueNode returnVal = front;
		
		if( returnVal == null ) throw new Exception("Deq called on empty queue");
		if( returnVal.rest == null ) back = null;
		front = returnVal.rest;
		
		return returnVal.first;
	}
		
	

}
