/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XColor;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.MouseAction;
import edu.neu.ccs.gui.MouseActionAdapter;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.gui.TypedView;
import edu.neu.ccs.util.DimensionUtilities;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.JPTError;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;

public class ColorView
extends DisplayPanel
implements TypedView,
JPTConstants {
    public static final String COLOR_PROPERTY = "color";
    public static final String DEFAULT_COLOR_PROPERTY = "default color";
    public static final String CHOOSER_CLICK_COUNT_PROPERTY = "chooser click count";
    protected static final Color DEFAULT_COLOR = SystemColor.text;
    protected static final String DEFAULT_COLOR_STRING = new XColor(DEFAULT_COLOR).toStringData();
    protected static final int DEFAULT_CHOOSER_CLICK_COUNT = 2;
    protected static final Dimension DEFAULT_DIMENSION = new Dimension(20, 20);
    JComponent colorBox = new JComponent(){

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(ColorView.this.getColor());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    };
    TextFieldView colorField = new TextFieldView(DEFAULT_COLOR_STRING, "Fix \"r,g,b\" or \"r,g,b,alpha\" values", "Malformed color");
    protected Color currentColor = DEFAULT_COLOR;
    protected Color defaultColor = DEFAULT_COLOR;
    protected int chooserClickCount = 2;
    protected InputProperties properties = new InputProperties();
    protected MouseActionAdapter mouseActions = null;
    protected Action setColorFromField = new SimpleAction("Set Color"){

        public void perform() {
            ColorView.this.setColorFromField();
        }
    };
    static /* synthetic */ Class class$edu$neu$ccs$XColor;

    public ColorView() {
        this((Color)null, false);
    }

    public ColorView(Color color) {
        this(color, false);
    }

    public ColorView(Color color, boolean bl) {
        this.installColorBox(color);
        this.installColorField(bl);
        this.installMouseActions();
        this.reset();
    }

    public Stringable demandObject() {
        return new XColor(this.getColor());
    }

    public Stringable requestObject() {
        return this.demandObject();
    }

    public void setInputProperties(InputProperties inputProperties) {
        InputProperties inputProperties2 = this.getInputProperties();
        this.properties = inputProperties;
        if (this.getInputProperties() != null && !this.getInputProperties().equals(inputProperties2)) {
            this.firePropertyChange("input.properties", inputProperties2, this.getInputProperties());
        }
    }

    public InputProperties getInputProperties() {
        return this.properties;
    }

    public Class getDataType() {
        return class$edu$neu$ccs$XColor == null ? (class$edu$neu$ccs$XColor = ColorView.class$("edu.neu.ccs.XColor")) : class$edu$neu$ccs$XColor;
    }

    public void setViewState(String string) {
        this.setColor(ColorView.parseColor(string, "setViewState"));
        this.firePropertyChange("view.state", null, string);
    }

    public String getViewState() {
        return this.demandObject().toStringData();
    }

    public void setDefaultViewState(String string) {
        this.defaultColor = ColorView.parseColor(string, "setDefaultViewState");
        this.colorField.setDefaultViewState(string);
        this.firePropertyChange("default.view.state", null, string);
    }

    public String getDefaultViewState() {
        XColor xColor = new XColor(this.defaultColor);
        return xColor.toStringData();
    }

    public void reset() {
        this.setColor(this.defaultColor);
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        Color color2 = this.currentColor;
        this.currentColor = color;
        this.colorBox.repaint();
        XColor xColor = new XColor(color);
        this.colorField.setViewState(xColor.toStringData());
        if (!color.equals(color2)) {
            this.firePropertyChange(COLOR_PROPERTY, color2, color);
        }
    }

    public Color getColor() {
        return this.currentColor;
    }

    public void setDefaultColor(Color color) {
        if (color == null) {
            return;
        }
        Color color2 = this.defaultColor;
        this.defaultColor = color;
        this.colorField.setDefaultViewState(this.getDefaultViewState());
        if (!color.equals(color2)) {
            this.firePropertyChange(DEFAULT_COLOR_PROPERTY, color2, color);
        }
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setAbsoluteSize(Dimension dimension) {
        dimension = dimension == null ? DEFAULT_DIMENSION : DimensionUtilities.createDimension(dimension);
        this.colorBox.setMinimumSize(dimension);
        this.colorBox.setMaximumSize(dimension);
        this.colorBox.setPreferredSize(dimension);
        this.revalidate();
    }

    public void setAbsoluteSize(int n, int n2) {
        this.setAbsoluteSize(new Dimension(n, n2));
    }

    public void setChooserClickCount(int n) {
        int n2 = this.chooserClickCount;
        this.chooserClickCount = n <= 1 ? 1 : 2;
        if (this.chooserClickCount != n2) {
            this.firePropertyChange(CHOOSER_CLICK_COUNT_PROPERTY, n2, this.chooserClickCount);
        }
    }

    public int getChooserClickCount() {
        return this.chooserClickCount;
    }

    public void setMouseActionAdapter(MouseActionAdapter mouseActionAdapter) {
        if (mouseActionAdapter == null) {
            return;
        }
        this.mouseActions = mouseActionAdapter;
    }

    public MouseActionAdapter getMouseActionAdapter() {
        return this.mouseActions;
    }

    protected static Color parseColor(String string, String string2) {
        try {
            return new XColor(string).getValue();
        }
        catch (ParseException parseException) {
            throw new JPTError("Malformed data in ColorView." + string2 + ": " + string);
        }
    }

    protected void setColorFromField() {
        XColor xColor = (XColor)this.colorField.demandObject();
        this.setColor(xColor.getValue());
    }

    protected void installColorBox(Color color) {
        if (color != null) {
            this.setDefaultColor(color);
        } else {
            this.setDefaultColor(DEFAULT_COLOR);
        }
        this.setAbsoluteSize(DEFAULT_DIMENSION);
        this.colorBox.setBorder(new LineBorder(Color.black, 1));
        this.add(this.colorBox);
    }

    protected void installColorField(boolean bl) {
        this.colorField.setDataType(class$edu$neu$ccs$XColor == null ? (class$edu$neu$ccs$XColor = ColorView.class$("edu.neu.ccs.XColor")) : class$edu$neu$ccs$XColor);
        this.colorField.setPreferredWidth(120);
        String string = this.getDefaultViewState();
        this.colorField.setDefaultViewState(string);
        this.colorField.getInputProperties().setSuggestion(string);
        this.colorField.addActionListener(this.setColorFromField);
        if (bl) {
            this.add(this.colorField);
        }
    }

    protected void installMouseActions() {
        this.mouseActions = new MouseActionAdapter(this.colorBox);
        this.mouseActions.addMouseClickedAction(new MouseAction(){

            public void mouseActionPerformed(MouseEvent mouseEvent) {
                Color color;
                if (ColorView.this.colorBox.isEnabled() && mouseEvent.getClickCount() >= ColorView.this.chooserClickCount && (color = JColorChooser.showDialog(new JLabel("Choose Color:"), "", ColorView.this.getColor())) != null) {
                    ColorView.this.setColor(color);
                }
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

