/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Comparator;

public class PriorityQueue
implements Queueable {
    Comparator c;
    ArrayList tree = new ArrayList();

    PriorityQueue(Comparator aC) {
        this.tree.add(null);
        this.c = aC;
    }

    public void enq(Object add) {
        int position = this.tree.size();
        this.tree.add(add);
        this.bubbleUp(position);
    }

    void bubbleUp(int pos) {
        int parent = pos / 2;
        if (parent == 0) {
            return;
        }
        if (this.c.compare(this.tree.get(pos), this.tree.get(parent)) > 0) {
            this.swap(parent, pos);
            this.bubbleUp(parent);
        }
    }

    void swap(int pos1, int pos2) {
        Object temp = this.tree.get(pos1);
        this.tree.set(pos1, this.tree.get(pos2));
        this.tree.set(pos2, temp);
    }

    void bubbleDown(int pos) {
        int child1 = pos * 2;
        int child2 = pos * 2 + 1;
        if (child1 < this.tree.size() && child2 < this.tree.size()) {
            if (this.c.compare(this.tree.get(child1), this.tree.get(pos)) > 0 && this.c.compare(this.tree.get(child1), this.tree.get(child2)) >= 0) {
                this.swap(child1, pos);
                this.bubbleDown(child1);
            } else if (this.c.compare(this.tree.get(child2), this.tree.get(pos)) > 0 && this.c.compare(this.tree.get(child2), this.tree.get(child1)) >= 0) {
                this.swap(child2, pos);
                this.bubbleDown(child2);
            }
        } else if (child1 < this.tree.size() && this.c.compare(this.tree.get(child1), this.tree.get(pos)) > 0) {
            this.swap(child1, pos);
            this.bubbleDown(child1);
        }
    }

    public boolean isEmpty() {
        return this.tree.size() == 1;
    }

    public Object peek() {
        return this.tree.get(1);
    }

    public Object deq() throws Exception {
        if (this.tree.size() == 1) {
            throw new Exception("Deq called on empty queue");
        }
        Object returnVal = this.tree.get(1);
        this.tree.set(1, this.tree.get(this.tree.size() - 1));
        this.tree.remove(this.tree.size() - 1);
        this.bubbleDown(1);
        return returnVal;
    }
}

