/* TestSuite.java  16 April 2003 */

import edu.neu.ccs.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.awt.*;
import java.math.*;
import java.util.*;

public class TestSuite extends JPFalt {
    public static void main(String[] args) { new TestSuite(); }
    
    /*---------------------------------------------------------------------- 
     * Test buffered file channel and iterator for input of list of cities
     *---------------------------------------------------------------------- */
    void TestInFileRangeBuffered(){
        int count = 0;
        println("Testing InFileRangeBuffered input iterator");

        for (IRange it = new InFileRangeBuffered();
             it.hasMore();
             it.next()){
            ZipCode current = (ZipCode)it.current();
            if (count < 50)
                println("Next in City: " + current);
            else if (count == 50) 
                println("Not displaying the rest of the cities.");
            
            count++;
            
        }
        println("Read " + count + " cities from file input iterator.\n");
    }

    /*---------------------------------------------------------------------- *
     * Test Populations
     *---------------------------------------------------------------------- */

    // Tests Populations class on simple, known data with expected answers.
    void TestPopulationsSimple() {
        println("Testing Populations on simple input and expected values");
        ZipCode[] zips = 
            new ZipCode[] {
                new ZipCode(00001, "Never", "Never Land", -2.0, 0.0, 547),
                new ZipCode(00002, "Never", "Never Land", -2.1, 0.0, 789),
                new ZipCode(00003, "Middle", "Nowhere", 90.0, 90.0, 3000)
            };
        IRange input = new IteratorRange(Arrays.asList(zips).iterator());

        Populations pop = new Populations(input);

        expected(547 + 789);
        actual(pop.getCityPopulation(new City("Never", "Never Land")));

        expected(3000);
        actual(pop.getCityPopulation(new City("Middle", "Nowhere")));

        expected(0);
        actual(pop.getCityPopulation(new City("Not in this list", "")));
        println();
    }

    // Runs Populations on large dataset, shows populations for several 
    // cities. Actual results are not compared with expected values.
    void TestPopulationsMore() {
        println("Exercising Populations on large dataset");

        City[] cities = new City[] {
            new City("Boston", "MA"),
            new City("New York", "NY"),
            new City("Houston", "TX"),
            new City("Sacramento", "CA"),
            new City("Richmond", "VA"),
            new City("Walla Walla", "WA"),
            new City("Wetumpka", "AL"),
            new City("New Orleans", "LA"),
            new City("New Haven", "CT"),
            new City("Milwaukee", "WI"),
            new City("Las Vegas", "NV"),
            new City("Doesn't Exist", "NW")
        };
        int[] pops = new int[cities.length];

        IRange input = new InFileRangeBuffered();
        Populations pop = new Populations(input);

        long start = System.currentTimeMillis();
        for (int ai = 0; ai < cities.length; ++ai) {
            pops[ai] = pop.getCityPopulation(cities[ai]);
        }
        long end = System.currentTimeMillis();

        for (int ai = 0; ai < cities.length; ++ai) {

            println(cities[ai].name + ": " + pops[ai]);
        }

        println("Lookups took " + (end-start) + " milliseconds\n");
    }

    // Tests the performance of Populations
    // Builds the Populations object and then does a lookup on every
    // key in the hashtable. Results of lookup are not shown.
    void PerformanceTest() {
        println("Testing performance of Populations");
        IRange input = new InFileRangeBuffered();
        Populations pop = new Populations(input);

        long start = System.currentTimeMillis();
        for (Iterator ki = pop.cityPopulations.keySet().iterator();
             ki.hasNext();) {
            pop.getCityPopulation((City)ki.next()); 
        }
        long end = System.currentTimeMillis();
        println("Scanning every city took " + (end-start) + " milliseconds\n");
    }
}
