import java.util.Iterator;

/* A Wrapper around java.util.Iterator to provide the IRange interface
 */
class IteratorRange implements IRange {
    /* wrapped iterator, current object, and validity flag */
    Iterator iterator;
    Object current;
    boolean currentValid;

    /* Constructor: initially, there is no current object
     */
    public IteratorRange(Iterator iterator) {
        this.iterator = iterator;
        this.current = null;
        this.currentValid = false;
    }

    /* The IRange interface methods */
    public boolean hasMore() {
        return currentValid || iterator.hasNext();
    }
    public Object current() {
        if (currentValid) return current;
        current = iterator.next();
        currentValid = true;
        return current;
    }
    public void next() {
        current = null;
        currentValid = false;
    }
}
