/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern:
   iterator for a list of cities 
*/

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.io.*;
import javax.swing.*;
import java.util.*;

/** An input iterator for ZipCode object from file input. */
class InFileRangeBuffered implements IRange{
    
    /*-------------------------------------------------------- 
     * Member data
     *------------------------------------------------------*/
    
    /* the input reader */
    protected BufferedReader buffer;
    
    /* one line of input at a time */
    protected String line;
    
    /* a Zip Code object to hold values */
    protected ZipCode zc;
    
    /* determines whether the general dialog has been closed */
    protected boolean closed = true;
    
    /* determines whether new zip code data has been submitted */
    protected boolean submitted = false;
    
    /*-------------------------------------------------------- 
     * Constructor
     *------------------------------------------------------*/    
    public InFileRangeBuffered() {
        
        /* build a file chooser and have the user choose a file,
         * quitting this operation if the user cancelled the choice
         */
        JFileChooser chooser = new JFileChooser(".");
        
        /** set the file extension to be .txt */
        chooser.setFileFilter(new FileView.ExtensionFileFilter("txt"));
        
        closed = false;
        
        /** see if file was selected - quit if user canceled */
        if (chooser.showOpenDialog(null) != JFileChooser.APPROVE_OPTION){
            closed = true;
            return;
        }
        try{
            buffer = new BufferedReader
                (new FileReader(chooser.getSelectedFile()));
        }
        catch(FileNotFoundException e){
            System.out.println("File not found exception: " + e);
            closed = true;        
        }
        
        /** read one line of input from the selected file
         * and extract values for the first object */
        next();
    }
    /*------------------------------------------------------
     * Methods to implement the IRange interface
     *------------------------------------------------------*/

    /** process next item, if available */
    public void next() {

        if (!closed)
            try{
                if (buffer.ready()){
            
                    line = new String(buffer.readLine());
                    if ((line == null)||(line == "")){     
                        buffer.close();
                        closed = true;
                    }
                    else{ 
                        read(line);
                    }            
                }
                else{
                    buffer.close();
                    closed = true;
                }
            }
            catch(Exception e) {
                System.out.println("Error in reading line exception: " + e);
                closed = true;
            }
        
    }

    /** return the most recent submission - if available */
    public Object current() {
           
        if (!closed)
            return zc;
        else{
            closed = true;
            return null;
        }
    }
    
    /** verify that new submission is available */
    public boolean hasMore() {
        return (!closed); 
    }
    
    /** extract next ZipCode object from the input string */
    public void read(String s){
        
        try {
            zc = new ZipCode();
            zc.fromStringData(line);
        } catch(java.text.ParseException e){
            System.out.println(e.getMessage() + 
                               " parse exception in line\n" + 
                               line);
            zc = null;
            closed = true;
        }
    }
}
