/* City represents a particular city within a state. */
class City {
    /* the name of the city */
    String name;

    /* the state in which the city is located */
    String state;

    /* --------------------
     * Constructor
     * -------------------- */

    /* full constructor */
    public City(String name, String state) {
        this.name = name;
        this.state = state;
    }

    /* --------------------
     * Methods
     * -------------------- */

    /* standard toString */
    public String toString() {
        return "new " + getClass() + "(" + 
            this.name + ", " + 
            this.state + ")";
    }

    /* extensional equality on City: contents are equal */
    public boolean equals(Object o) {
        if (o instanceof City) {
            City c = (City) o;
            return this.name.equals(c.name)
                && this.state.equals(c.state);
        } else { 
            return false;
        }
    }

    /* hashCode just uses the state's hashCode
     * This satisfies the requirement that if two objects are
     * extensionally equal, then their hashcodes are the same
     */
    public int hashCode() {
        return this.state.hashCode();
    }
}
