/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ActionSequence;
import edu.neu.ccs.gui.MouseActionEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.event.MouseInputListener;

public class MouseActionAdapter
implements MouseInputListener,
Cloneable,
Serializable {
    protected ActionSequence clickedActions = new ActionSequence();
    protected ActionSequence enteredActions = new ActionSequence();
    protected ActionSequence exitedActions = new ActionSequence();
    protected ActionSequence pressedActions = new ActionSequence();
    protected ActionSequence releasedActions = new ActionSequence();
    protected ActionSequence draggedActions = new ActionSequence();
    protected ActionSequence movedActions = new ActionSequence();

    public MouseActionAdapter() {
        this(null);
    }

    public MouseActionAdapter(Component component) {
        this.addAsListenerTo(component);
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
        this.clickedActions.actionPerformed(new MouseActionEvent(mouseEvent, mouseEvent.getSource()));
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
        this.enteredActions.actionPerformed(new MouseActionEvent(mouseEvent, mouseEvent.getSource()));
    }

    public final void mouseExited(MouseEvent mouseEvent) {
        this.exitedActions.actionPerformed(new MouseActionEvent(mouseEvent, mouseEvent.getSource()));
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        this.pressedActions.actionPerformed(new MouseActionEvent(mouseEvent, mouseEvent.getSource()));
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        this.releasedActions.actionPerformed(new MouseActionEvent(mouseEvent, mouseEvent.getSource()));
    }

    public final void mouseDragged(MouseEvent mouseEvent) {
        this.draggedActions.actionPerformed(new MouseActionEvent(mouseEvent, mouseEvent.getSource()));
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
        this.movedActions.actionPerformed(new MouseActionEvent(mouseEvent, mouseEvent.getSource()));
    }

    public void addAsListenerTo(Component component) {
        if (component == null) {
            return;
        }
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    public void removeAsListenerTo(Component component) {
        if (component == null) {
            return;
        }
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
    }

    public void addMouseClickedAction(Action action) {
        this.clickedActions.add(action);
    }

    public void addMouseEnteredAction(Action action) {
        this.enteredActions.add(action);
    }

    public void addMouseExitedAction(Action action) {
        this.exitedActions.add(action);
    }

    public void addMousePressedAction(Action action) {
        this.pressedActions.add(action);
    }

    public void addMouseReleasedAction(Action action) {
        this.releasedActions.add(action);
    }

    public void addMouseDraggedAction(Action action) {
        this.draggedActions.add(action);
    }

    public void addMouseMovedAction(Action action) {
        this.movedActions.add(action);
    }

    public void removeMouseClickedAction(Action action) {
        this.clickedActions.remove(action);
    }

    public void removeMouseEnteredAction(Action action) {
        this.enteredActions.remove(action);
    }

    public void removeMouseExitedAction(Action action) {
        this.exitedActions.remove(action);
    }

    public void removeMousePressedAction(Action action) {
        this.pressedActions.remove(action);
    }

    public void removeMouseReleasedAction(Action action) {
        this.releasedActions.remove(action);
    }

    public void removeMouseDraggedAction(Action action) {
        this.draggedActions.remove(action);
    }

    public void removeMouseMovedAction(Action action) {
        this.movedActions.remove(action);
    }

    public void setMouseClickedActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.clickedActions.clear();
        } else {
            this.clickedActions = actionSequence;
        }
    }

    public void setMouseEnteredActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.enteredActions.clear();
        } else {
            this.enteredActions = actionSequence;
        }
    }

    public void setMouseExitedActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.exitedActions.clear();
        } else {
            this.exitedActions = actionSequence;
        }
    }

    public void setMousePressedActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.pressedActions.clear();
        } else {
            this.pressedActions = actionSequence;
        }
    }

    public void setMouseReleasedActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.releasedActions.clear();
        } else {
            this.releasedActions = actionSequence;
        }
    }

    public void setMouseDraggedActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.draggedActions.clear();
        } else {
            this.draggedActions = actionSequence;
        }
    }

    public void setMouseMovedActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.movedActions.clear();
        } else {
            this.movedActions = actionSequence;
        }
    }

    public ActionSequence getMouseClickedActions() {
        return this.clickedActions;
    }

    public ActionSequence getMouseEnteredActions() {
        return this.enteredActions;
    }

    public ActionSequence getMouseExitedActions() {
        return this.exitedActions;
    }

    public ActionSequence getMousePressedActions() {
        return this.pressedActions;
    }

    public ActionSequence getMouseReleasedActions() {
        return this.releasedActions;
    }

    public ActionSequence getMouseDraggedActions() {
        return this.draggedActions;
    }

    public ActionSequence getMouseMovedActions() {
        return this.movedActions;
    }
}

