/* TestSuite.java  16 April 2003 */

import edu.neu.ccs.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.awt.*;
import java.math.*;
import java.util.*;

public class TestSuite extends JPFalt {
    public static void main(String[] args) { new TestSuite(); }
    
    ///////////////////////////////////////////////////////////
    // Place your actual methods here.                       //
    ///////////////////////////////////////////////////////////
    /*----------------------------------------------------------------------- 
     * Test city constructors
     *----------------------------------------------------------------------- */
    void TestCity(){
	
        City nyc = new City();
        println(nyc);
        
        City boston = new City(02115, "Boston", "MA", 71.092215, 42.342706);
        println(boston);
        
        City bos = new City(boston);
        println(boston);
        
        println("Testing zip code converter");
        expected(12345);
        actual(boston.decimal("12345"));
        
        expected(2145);
        actual(boston.decimal("02145"));
        
        LinkedList list = new LinkedList();
        println(list);
        
        expected(true);
        actual(list.isEmpty());
        
        list.addCity(nyc);
        println(list);
        
        expected(false);
        actual(list.isEmpty());
        
        list.addCity(boston);
        println(list);
                
        list.addCity(boston);
        println(list);
        
        list.remove();
        println(list);
        
        expected(new City(02115, "Boston", "MA", 71.092215, 42.342706));
        actual(list.getFirst());
        
                
    }
    
    /*----------------------------------------------------------------------- 
     * Test GUI iterator for input of list of cities
     *----------------------------------------------------------------------- */
    void TestInGuiRange(){
        AList cities = new EmptyList();
        
        for (IRange it = new InGuiRange();
             it.hasMore();
             it.next()){
            cities = new ConsList((City)it.current(), cities);
            println("Next in City: " + ((ConsList)cities).first);
        }
        
        println("Done with gui input iterator.");
    }

    /*----------------------------------------------------------------------- 
     * Test buffered file channel and iterator for input of list of cities
     *----------------------------------------------------------------------- */
    void TestInFileRangeBuffered(){
	
        City[] cities = new City[20];
        int i = 0;
        
        for (IRange it = new InFileRangeBuffered();
             it.hasMore();
             it.next()){
        
            cities[i] = (City)it.current();
            println("Next in City: " + cities[i]);
            i++;
            
        }
        
        println("Done with buffered file input iterator.");
    }

    /*-----------------------------------------------------------------------
     * Test console channel and iterator for input of list of balloons
     *----------------------------------------------------------------------- */
    void TestInConsoleRange(){
    
        City[] cities = new City[20];
        int i = 0;
        
        for (InConsoleRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            println("loop");
            cities[i] = (City)it.current();
            
            println(cities[i]);
            i++;
        }
    }

    /*-----------------------------------------------------------------------
     * Utility methods
     *----------------------------------------------------------------------- */

    /** convert a String to int - if possible */
    protected int intValue(String s){
        int n = 0;
        try{
            n = (new XInt(s)).intValue();
        }
        catch(java.text.ParseException e){
            println("Cannot convert " + s + " to integer.");
        }
        return n;
    }
}

