/*
 * @(#)LinkedList.java  30 April 2003
 */

/**
 * Linked list of cities class
 */
public class LinkedList {

/*---------------------------------------------------------------
 Member data
 --------------------------------------------------------------*/
    public ListNode first;
    
/*---------------------------------------------------------------
 Constructor
 --------------------------------------------------------------*/
    public LinkedList(ListNode aFirst) {
        this.first = aFirst;
    }

    public LinkedList() {
        this(ListNode.sentinel);
    }

/*---------------------------------------------------------------
 Methods
 --------------------------------------------------------------*/

	/* add a node with given city data to the list */
	public void addCity(City aCity){
		this.first = new ListNode(aCity, this.first);
	}
	
	/* determine whether this is an empty list */
	public boolean isEmpty(){
		return ((this.first == ListNode.sentinel)); 
	}
	
	/* return the city at the front of the list */
	public City getFirst(){
		return this.first.data;
	}
	
	/* remove first node from this list; return false if empty */
	public boolean remove(){
		if (isEmpty())
			return false;
		
		this.first = this.first.next;
		return true;
	}

 /*---------------------------------------------------------------
 Print all member data values.
 --------------------------------------------------------------*/
	public String toString(){
		return("\nnew " + getClass().getName() + "(" + 
					first  + ")");
	}
    
}
