/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.parser;

import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XBoolean;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.parser.AbstractParser;
import edu.neu.ccs.parser.ParserUtilities;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Vector;

public class JPTParser
extends AbstractParser {
    protected NumericOperation opPlus;
    protected NumericOperation opMinus;
    protected NumericOperation opTimes;
    protected NumericOperation opSlash;
    protected NumericOperation opPercent;
    protected BooleanOperation opEQ;
    protected BooleanOperation opNE;
    protected BooleanOperation opLT;
    protected BooleanOperation opGT;
    protected BooleanOperation opLE;
    protected BooleanOperation opGE;
    protected BooleanOperation opAND;
    protected BooleanOperation opOR;
    protected BooleanOperation opNOT;
    protected AbstractParser.Procedure procAbs;
    protected AbstractParser.Procedure procCeiling;
    protected AbstractParser.Procedure procFloor;
    protected AbstractParser.Procedure procRound;
    protected AbstractParser.Procedure procMax;
    protected AbstractParser.Procedure procMin;
    protected AbstractParser.Procedure procSqrt;
    protected AbstractParser.Procedure procPower;
    protected AbstractParser.Procedure procToDegrees;
    protected AbstractParser.Procedure procToRadians;
    protected AbstractParser.Procedure procSin;
    protected AbstractParser.Procedure procSinDeg;
    protected AbstractParser.Procedure procCos;
    protected AbstractParser.Procedure procCosDeg;
    protected AbstractParser.Procedure procTan;
    protected AbstractParser.Procedure procTanDeg;
    protected AbstractParser.Procedure procASin;
    protected AbstractParser.Procedure procASinDeg;
    protected AbstractParser.Procedure procACos;
    protected AbstractParser.Procedure procACosDeg;
    protected AbstractParser.Procedure procATan;
    protected AbstractParser.Procedure procATanDeg;
    protected AbstractParser.Procedure procATan2;
    protected AbstractParser.Procedure procATan2Deg;
    protected AbstractParser.Procedure procExp;
    protected AbstractParser.Procedure procLn;
    protected AbstractParser.Procedure procLog;
    protected AbstractParser.Procedure procLogToBase;
    protected AbstractParser.Procedure procRandom;

    public Object parse(String string) throws ParseException {
        this.data = string;
        this.next = 0;
        if (this.data == null) {
            throw new ParseException("Input was null.", -1);
        }
        AbstractParser.ObjectOperationPair objectOperationPair = this.parseExpression(new AbstractParser.ObjectOperationPair(null, this.identity));
        Object object = objectOperationPair.value;
        if (object == null) {
            throw new ParseException("Expected expression.", this.next);
        }
        if (this.next < this.data.length()) {
            throw new ParseException("Expected end of expression.", this.next);
        }
        return object;
    }

    protected void defineNumericOperations() {
        this.opPlus = new NumericOperation("+", true, true){

            public Object unaryForXIntegral(XBigInteger xBigInteger) {
                return xBigInteger;
            }

            public Object binaryForXIntegral(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
                BigInteger bigInteger = xBigInteger.getValue();
                BigInteger bigInteger2 = xBigInteger2.getValue();
                return new XBigInteger(bigInteger.add(bigInteger2));
            }

            public Object unaryForXFloating(XDouble xDouble) {
                return xDouble;
            }

            public Object binaryForXFloating(XDouble xDouble, XDouble xDouble2) {
                double d = xDouble.getValue();
                double d2 = xDouble2.getValue();
                return new XDouble(d + d2);
            }
        };
        this.opMinus = new NumericOperation("-", true, true){

            public Object unaryForXIntegral(XBigInteger xBigInteger) {
                BigInteger bigInteger = xBigInteger.getValue();
                return new XBigInteger(bigInteger.negate());
            }

            public Object binaryForXIntegral(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
                BigInteger bigInteger = xBigInteger.getValue();
                BigInteger bigInteger2 = xBigInteger2.getValue();
                return new XBigInteger(bigInteger.subtract(bigInteger2));
            }

            public Object unaryForXFloating(XDouble xDouble) {
                double d = xDouble.getValue();
                return new XDouble(-d);
            }

            public Object binaryForXFloating(XDouble xDouble, XDouble xDouble2) {
                double d = xDouble.getValue();
                double d2 = xDouble2.getValue();
                return new XDouble(d - d2);
            }
        };
        this.opTimes = new NumericOperation("*", false, true){

            public Object binaryForXIntegral(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
                BigInteger bigInteger = xBigInteger.getValue();
                BigInteger bigInteger2 = xBigInteger2.getValue();
                return new XBigInteger(bigInteger.multiply(bigInteger2));
            }

            public Object binaryForXFloating(XDouble xDouble, XDouble xDouble2) {
                double d = xDouble.getValue();
                double d2 = xDouble2.getValue();
                return new XDouble(d * d2);
            }
        };
        this.opSlash = new NumericOperation("/", false, true){

            public Object binaryForXIntegral(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
                BigInteger bigInteger = xBigInteger.getValue();
                BigInteger bigInteger2 = xBigInteger2.getValue();
                if (bigInteger2.equals(BigInteger.ZERO)) {
                    int n = bigInteger.compareTo(BigInteger.ZERO);
                    if (n > 0) {
                        return new XDouble(Double.POSITIVE_INFINITY);
                    }
                    if (n < 0) {
                        return new XDouble(Double.NEGATIVE_INFINITY);
                    }
                    return new XDouble(Double.NaN);
                }
                return new XBigInteger(bigInteger.divide(bigInteger2));
            }

            public Object binaryForXFloating(XDouble xDouble, XDouble xDouble2) {
                double d = xDouble.getValue();
                double d2 = xDouble2.getValue();
                return new XDouble(d / d2);
            }
        };
        this.opPercent = new NumericOperation("%", false, true){

            public Object binaryForXIntegral(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
                BigInteger bigInteger = xBigInteger.getValue();
                BigInteger bigInteger2 = xBigInteger2.getValue();
                if (bigInteger2.equals(BigInteger.ZERO)) {
                    return new XDouble(Double.NaN);
                }
                return new XBigInteger(bigInteger.remainder(bigInteger2));
            }

            public Object binaryForXFloating(XDouble xDouble, XDouble xDouble2) {
                double d = xDouble.getValue();
                double d2 = xDouble2.getValue();
                return new XDouble(d % d2);
            }
        };
    }

    protected void defineBooleanOperations() {
        this.opEQ = new BooleanOperation("==", false, true, true){

            public Object binaryForXBoolean(XBoolean xBoolean, XBoolean xBoolean2) {
                boolean bl;
                boolean bl2 = xBoolean.getValue();
                return new XBoolean(bl2 == (bl = xBoolean2.getValue()));
            }

            public Object binaryForXIntegral(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
                BigInteger bigInteger;
                BigInteger bigInteger2 = xBigInteger.getValue();
                int n = bigInteger2.compareTo(bigInteger = xBigInteger2.getValue());
                return new XBoolean(n == 0);
            }

            public Object binaryForXFloating(XDouble xDouble, XDouble xDouble2) {
                double d;
                double d2 = xDouble.getValue();
                return new XBoolean(d2 == (d = xDouble2.getValue()));
            }
        };
        this.opNE = new BooleanOperation("!=", false, true, true){

            public Object binaryForXBoolean(XBoolean xBoolean, XBoolean xBoolean2) {
                boolean bl;
                boolean bl2 = xBoolean.getValue();
                return new XBoolean(bl2 != (bl = xBoolean2.getValue()));
            }

            public Object binaryForXIntegral(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
                BigInteger bigInteger;
                BigInteger bigInteger2 = xBigInteger.getValue();
                int n = bigInteger2.compareTo(bigInteger = xBigInteger2.getValue());
                return new XBoolean(n != 0);
            }

            public Object binaryForXFloating(XDouble xDouble, XDouble xDouble2) {
                double d;
                double d2 = xDouble.getValue();
                return new XBoolean(d2 != (d = xDouble2.getValue()));
            }
        };
        this.opLT = new BooleanOperation("<", false, true, true){

            public Object binaryForXBoolean(XBoolean xBoolean, XBoolean xBoolean2) {
                boolean bl = xBoolean.getValue();
                boolean bl2 = xBoolean2.getValue();
                return new XBoolean(!bl && bl2);
            }

            public Object binaryForXIntegral(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
                BigInteger bigInteger;
                BigInteger bigInteger2 = xBigInteger.getValue();
                int n = bigInteger2.compareTo(bigInteger = xBigInteger2.getValue());
                return new XBoolean(n < 0);
            }

            public Object binaryForXFloating(XDouble xDouble, XDouble xDouble2) {
                double d;
                double d2 = xDouble.getValue();
                return new XBoolean(d2 < (d = xDouble2.getValue()));
            }
        };
        this.opGT = new BooleanOperation(">", false, true, true){

            public Object binaryForXBoolean(XBoolean xBoolean, XBoolean xBoolean2) {
                boolean bl = xBoolean.getValue();
                boolean bl2 = xBoolean2.getValue();
                return new XBoolean(bl && !bl2);
            }

            public Object binaryForXIntegral(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
                BigInteger bigInteger;
                BigInteger bigInteger2 = xBigInteger.getValue();
                int n = bigInteger2.compareTo(bigInteger = xBigInteger2.getValue());
                return new XBoolean(n > 0);
            }

            public Object binaryForXFloating(XDouble xDouble, XDouble xDouble2) {
                double d;
                double d2 = xDouble.getValue();
                return new XBoolean(d2 > (d = xDouble2.getValue()));
            }
        };
        this.opLE = new BooleanOperation("<=", false, true, true){

            public Object binaryForXBoolean(XBoolean xBoolean, XBoolean xBoolean2) {
                boolean bl = xBoolean.getValue();
                boolean bl2 = xBoolean2.getValue();
                return new XBoolean(!bl || bl2);
            }

            public Object binaryForXIntegral(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
                BigInteger bigInteger;
                BigInteger bigInteger2 = xBigInteger.getValue();
                int n = bigInteger2.compareTo(bigInteger = xBigInteger2.getValue());
                return new XBoolean(n <= 0);
            }

            public Object binaryForXFloating(XDouble xDouble, XDouble xDouble2) {
                double d;
                double d2 = xDouble.getValue();
                return new XBoolean(d2 <= (d = xDouble2.getValue()));
            }
        };
        this.opGE = new BooleanOperation(">=", false, true, true){

            public Object binaryForXBoolean(XBoolean xBoolean, XBoolean xBoolean2) {
                boolean bl = xBoolean.getValue();
                boolean bl2 = xBoolean2.getValue();
                return new XBoolean(bl || !bl2);
            }

            public Object binaryForXIntegral(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
                BigInteger bigInteger;
                BigInteger bigInteger2 = xBigInteger.getValue();
                int n = bigInteger2.compareTo(bigInteger = xBigInteger2.getValue());
                return new XBoolean(n >= 0);
            }

            public Object binaryForXFloating(XDouble xDouble, XDouble xDouble2) {
                double d;
                double d2 = xDouble.getValue();
                return new XBoolean(d2 >= (d = xDouble2.getValue()));
            }
        };
        this.opAND = new BooleanOperation("&&", false, true, false){

            public Object binaryForXBoolean(XBoolean xBoolean, XBoolean xBoolean2) {
                boolean bl = xBoolean.getValue();
                boolean bl2 = xBoolean2.getValue();
                return new XBoolean(bl && bl2);
            }
        };
        this.opOR = new BooleanOperation("||", false, true, false){

            public Object binaryForXBoolean(XBoolean xBoolean, XBoolean xBoolean2) {
                boolean bl = xBoolean.getValue();
                boolean bl2 = xBoolean2.getValue();
                return new XBoolean(bl || bl2);
            }
        };
        this.opNOT = new BooleanOperation("!", true, false, false){

            public Object unaryForXBoolean(XBoolean xBoolean) {
                boolean bl = xBoolean.getValue();
                return new XBoolean(!bl);
            }
        };
    }

    protected void addOperations() {
        this.defineNumericOperations();
        this.defineBooleanOperations();
        this.addOperationAfterPrecedenceOf(this.identity, this.opOR);
        this.addOperationAfterPrecedenceOf(this.opOR, this.opAND);
        this.addOperationAfterPrecedenceOf(this.opAND, this.opEQ);
        this.addOperationAtPrecedenceOf(this.opEQ, this.opNE);
        this.addOperationAfterPrecedenceOf(this.opEQ, this.opLT);
        this.addOperationAtPrecedenceOf(this.opLT, this.opGT);
        this.addOperationAtPrecedenceOf(this.opLT, this.opLE);
        this.addOperationAtPrecedenceOf(this.opLT, this.opGE);
        this.addOperationAfterPrecedenceOf(this.opLT, this.opPlus);
        this.addOperationAtPrecedenceOf(this.opPlus, this.opMinus);
        this.addOperationAfterPrecedenceOf(this.opPlus, this.opTimes);
        this.addOperationAtPrecedenceOf(this.opTimes, this.opSlash);
        this.addOperationAtPrecedenceOf(this.opTimes, this.opPercent);
        this.addOperationAfterPrecedenceOf(this.opTimes, this.opNOT);
    }

    protected void defineProcedures() {
        this.procAbs = new AbstractParser.Procedure("abs", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                if (ParserUtilities.isXIntegral(objectArray[0])) {
                    XBigInteger xBigInteger = ParserUtilities.toXBigInteger((XNumber)objectArray[0]);
                    BigInteger bigInteger = xBigInteger.getValue();
                    int n = bigInteger.compareTo(BigInteger.ZERO);
                    if (n >= 0) {
                        return xBigInteger;
                    }
                    bigInteger = bigInteger.negate();
                    return new XBigInteger(bigInteger);
                }
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                if (d >= 0.0) {
                    return xDouble;
                }
                return new XDouble(-d);
            }
        };
        this.procCeiling = new AbstractParser.Procedure("ceiling", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                if (ParserUtilities.isXIntegral(objectArray[0])) {
                    XBigInteger xBigInteger = ParserUtilities.toXBigInteger((XNumber)objectArray[0]);
                    return xBigInteger;
                }
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                d = Math.ceil(d);
                return new XDouble(d);
            }
        };
        this.procFloor = new AbstractParser.Procedure("floor", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                if (ParserUtilities.isXIntegral(objectArray[0])) {
                    XBigInteger xBigInteger = ParserUtilities.toXBigInteger((XNumber)objectArray[0]);
                    return xBigInteger;
                }
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                d = Math.floor(d);
                return new XDouble(d);
            }
        };
        this.procRound = new AbstractParser.Procedure("round", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                if (ParserUtilities.isXIntegral(objectArray[0])) {
                    XBigInteger xBigInteger = ParserUtilities.toXBigInteger((XNumber)objectArray[0]);
                    return xBigInteger;
                }
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                d = Math.rint(d);
                return new XDouble(d);
            }
        };
        this.procMax = new AbstractParser.Procedure("max", 2){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                double d;
                this.checkArgs(objectArray);
                if (ParserUtilities.isXIntegral(objectArray[0]) && ParserUtilities.isXIntegral(objectArray[1])) {
                    BigInteger bigInteger;
                    XBigInteger xBigInteger = ParserUtilities.toXBigInteger((XNumber)objectArray[0]);
                    XBigInteger xBigInteger2 = ParserUtilities.toXBigInteger((XNumber)objectArray[1]);
                    BigInteger bigInteger2 = xBigInteger.getValue();
                    int n = bigInteger2.compareTo(bigInteger = xBigInteger2.getValue());
                    if (n >= 0) {
                        return xBigInteger;
                    }
                    return xBigInteger2;
                }
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                XDouble xDouble2 = ParserUtilities.toXDouble((XNumber)objectArray[1]);
                double d2 = xDouble.getValue();
                if (d2 >= (d = xDouble2.getValue())) {
                    return xDouble;
                }
                return xDouble2;
            }
        };
        this.procMin = new AbstractParser.Procedure("min", 2){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                double d;
                this.checkArgs(objectArray);
                if (ParserUtilities.isXIntegral(objectArray[0]) && ParserUtilities.isXIntegral(objectArray[1])) {
                    BigInteger bigInteger;
                    XBigInteger xBigInteger = ParserUtilities.toXBigInteger((XNumber)objectArray[0]);
                    XBigInteger xBigInteger2 = ParserUtilities.toXBigInteger((XNumber)objectArray[1]);
                    BigInteger bigInteger2 = xBigInteger.getValue();
                    int n = bigInteger2.compareTo(bigInteger = xBigInteger2.getValue());
                    if (n >= 0) {
                        return xBigInteger2;
                    }
                    return xBigInteger;
                }
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                XDouble xDouble2 = ParserUtilities.toXDouble((XNumber)objectArray[1]);
                double d2 = xDouble.getValue();
                if (d2 >= (d = xDouble2.getValue())) {
                    return xDouble2;
                }
                return xDouble;
            }
        };
        this.procSqrt = new AbstractParser.Procedure("sqrt", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                if (d == 0.0) {
                    return xDouble;
                }
                if (d > 0.0) {
                    return new XDouble(Math.sqrt(d));
                }
                throw new ParseException("Negative argument " + d + " to sqrt procedure", 0);
            }
        };
        this.procPower = new AbstractParser.Procedure("power", 2){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                XDouble xDouble2 = ParserUtilities.toXDouble((XNumber)objectArray[1]);
                double d = xDouble.getValue();
                double d2 = xDouble2.getValue();
                if (d == 0.0 && d2 > 0.0) {
                    return xDouble;
                }
                if (d > 0.0) {
                    return new XDouble(Math.pow(d, d2));
                }
                throw new ParseException("Invalid arguments " + d + "," + d2 + " to power procedure", 0);
            }
        };
        this.procToDegrees = new AbstractParser.Procedure("todegrees", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                return new XDouble(Math.toDegrees(d));
            }
        };
        this.procToRadians = new AbstractParser.Procedure("toradians", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                return new XDouble(Math.toRadians(d));
            }
        };
        this.procSin = new AbstractParser.Procedure("sin", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                return new XDouble(Math.sin(d));
            }
        };
        this.procSinDeg = new AbstractParser.Procedure("sindeg", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                return new XDouble(Math.sin(Math.toRadians(d)));
            }
        };
        this.procCos = new AbstractParser.Procedure("cos", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                return new XDouble(Math.cos(d));
            }
        };
        this.procCosDeg = new AbstractParser.Procedure("cosdeg", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                return new XDouble(Math.cos(Math.toRadians(d)));
            }
        };
        this.procTan = new AbstractParser.Procedure("tan", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                return new XDouble(Math.tan(d));
            }
        };
        this.procTanDeg = new AbstractParser.Procedure("tandeg", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                return new XDouble(Math.tan(Math.toRadians(d)));
            }
        };
        this.procASin = new AbstractParser.Procedure("asin", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                if (d < -1.0 || d > 1.0) {
                    throw new ParseException("Invalid argument " + d + " to asin procedure", 0);
                }
                return new XDouble(Math.asin(d));
            }
        };
        this.procASinDeg = new AbstractParser.Procedure("asindeg", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                if (d < -1.0 || d > 1.0) {
                    throw new ParseException("Invalid argument " + d + " to asindeg procedure", 0);
                }
                return new XDouble(Math.toDegrees(Math.asin(d)));
            }
        };
        this.procACos = new AbstractParser.Procedure("acos", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                if (d < -1.0 || d > 1.0) {
                    throw new ParseException("Invalid argument " + d + " to acos procedure", 0);
                }
                return new XDouble(Math.acos(d));
            }
        };
        this.procACosDeg = new AbstractParser.Procedure("acosdeg", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                if (d < -1.0 || d > 1.0) {
                    throw new ParseException("Invalid argument " + d + " to acosdeg procedure", 0);
                }
                return new XDouble(Math.toDegrees(Math.acos(d)));
            }
        };
        this.procATan = new AbstractParser.Procedure("atan", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                return new XDouble(Math.atan(d));
            }
        };
        this.procATanDeg = new AbstractParser.Procedure("atandeg", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                return new XDouble(Math.toDegrees(Math.atan(d)));
            }
        };
        this.procATan2 = new AbstractParser.Procedure("atan2", 2){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                XDouble xDouble2 = ParserUtilities.toXDouble((XNumber)objectArray[1]);
                double d = xDouble.getValue();
                double d2 = xDouble2.getValue();
                if (d2 == 0.0 && d == 0.0) {
                    throw new ParseException("Invalid arguments " + d2 + "," + d + " to atan2 procedure", 0);
                }
                return new XDouble(Math.atan2(d, d2));
            }
        };
        this.procATan2Deg = new AbstractParser.Procedure("atan2deg", 2){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                XDouble xDouble2 = ParserUtilities.toXDouble((XNumber)objectArray[1]);
                double d = xDouble.getValue();
                double d2 = xDouble2.getValue();
                if (d2 == 0.0 && d == 0.0) {
                    throw new ParseException("Invalid arguments " + d2 + "," + d + " to atan2deg procedure", 0);
                }
                return new XDouble(Math.toDegrees(Math.atan2(d, d2)));
            }
        };
        this.procExp = new AbstractParser.Procedure("exp", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                return new XDouble(Math.exp(d));
            }
        };
        this.procLn = new AbstractParser.Procedure("ln", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                if (d > 0.0) {
                    return new XDouble(Math.log(d));
                }
                throw new ParseException("Invalid argument " + d + " to ln procedure", 0);
            }
        };
        this.procLog = new AbstractParser.Procedure("log", 1){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                double d = xDouble.getValue();
                if (d > 0.0) {
                    return new XDouble(Math.log(d));
                }
                throw new ParseException("Invalid argument " + d + " to log procedure", 0);
            }
        };
        this.procLogToBase = new AbstractParser.Procedure("logtobase", 2){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                XDouble xDouble2 = ParserUtilities.toXDouble((XNumber)objectArray[1]);
                double d = xDouble.getValue();
                double d2 = xDouble2.getValue();
                if (d > 0.0 && d2 > 0.0) {
                    return new XDouble(Math.log(d) / Math.log(d2));
                }
                throw new ParseException("Invalid arguments " + d + "," + d2 + " to logtobase procedure", 0);
            }
        };
        this.procRandom = new AbstractParser.Procedure("random", 2){

            public Object procedureCall(Object[] objectArray) throws ParseException {
                this.checkArgs(objectArray);
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)objectArray[0]);
                XDouble xDouble2 = ParserUtilities.toXDouble((XNumber)objectArray[1]);
                double d = xDouble.getValue();
                double d2 = xDouble2.getValue();
                double d3 = Math.random();
                return new XDouble((1.0 - d3) * d + d3 * d2);
            }
        };
    }

    protected void addProcedures() {
        this.defineProcedures();
        this.addProcedure(this.procAbs);
        this.addProcedure(this.procCeiling);
        this.addProcedure(this.procFloor);
        this.addProcedure(this.procRound);
        this.addProcedure(this.procMax);
        this.addProcedure(this.procMin);
        this.addProcedure(this.procSqrt);
        this.addProcedure(this.procPower);
        this.addProcedure(this.procToDegrees);
        this.addProcedure(this.procToRadians);
        this.addProcedure(this.procSin);
        this.addProcedure(this.procSinDeg);
        this.addProcedure(this.procCos);
        this.addProcedure(this.procCosDeg);
        this.addProcedure(this.procTan);
        this.addProcedure(this.procTanDeg);
        this.addProcedure(this.procASin);
        this.addProcedure(this.procASinDeg);
        this.addProcedure(this.procACos);
        this.addProcedure(this.procACosDeg);
        this.addProcedure(this.procATan);
        this.addProcedure(this.procATanDeg);
        this.addProcedure(this.procATan2);
        this.addProcedure(this.procATan2Deg);
        this.addProcedure(this.procExp);
        this.addProcedure(this.procLn);
        this.addProcedure(this.procLog);
        this.addProcedure(this.procLogToBase);
        this.addProcedure(this.procRandom);
    }

    protected void addConstants() {
        this.addConstant("pi", new XDouble(Math.PI));
        this.addConstant("e", new XDouble(Math.E));
        this.addConstant("true", new XBoolean(true));
        this.addConstant("false", new XBoolean(false));
        this.addConstant("Infinity", new XDouble(Double.POSITIVE_INFINITY));
        this.addConstant("NaN", new XDouble(Double.NaN));
    }

    /*
     * Unable to fully structure code
     */
    protected AbstractParser.ObjectOperationPair parseExpression(AbstractParser.ObjectOperationPair var1_1) throws ParseException {
        var2_2 = var1_1.value;
        var3_3 = null;
        var4_4 = var1_1.operation;
        var5_5 = null;
        var6_6 = this.precedenceOf(var4_4);
        var7_7 = -1;
        if (var4_4 == null) {
            throw new ParseException("Expected binary operation.", this.next);
        }
        while (true) {
            var3_3 = this.nextTerm();
            var5_5 = this.nextOperation();
            var7_7 = this.precedenceOf(var5_5);
            if (var5_5 == null || var5_5.isBinary()) ** GOTO lbl19
            throw new ParseException("Expected binary operation.", this.next);
lbl-1000:
            // 1 sources

            {
                var8_8 = this.parseExpression(new AbstractParser.ObjectOperationPair(var3_3, var5_5));
                var3_3 = var8_8.value;
                var5_5 = var8_8.operation;
                var7_7 = this.precedenceOf(var5_5);
lbl19:
                // 2 sources

                ** while (var7_7 > var6_6)
            }
lbl20:
            // 1 sources

            var3_3 = var4_4.performOperation(var2_2, var3_3);
            if (var7_7 != var6_6) break;
            var2_2 = var3_3;
            var4_4 = var5_5;
        }
        return new AbstractParser.ObjectOperationPair(var3_3, var5_5);
    }

    protected Object nextTerm() throws ParseException {
        AbstractParser.Operation[] operationArray = this.nextUnaryOperations();
        int n = operationArray.length;
        Object object = this.nextSimpleTerm();
        int n2 = n - 1;
        while (n2 >= 0) {
            object = operationArray[n2].performOperation(null, object);
            --n2;
        }
        return object;
    }

    protected Object nextSimpleTerm() throws ParseException {
        Object object = null;
        if (this.nextTokenIs(this.NESTED_EXPRESSION_START)) {
            object = this.parseNestedExpression();
        } else if (this.startsNumber()) {
            object = this.parseNumber();
        } else if (this.startsIdentifier()) {
            String string = this.parseIdentifier();
            object = this.nextTokenIs(this.ARGUMENT_LIST_START) ? this.parseProcedureCall(string) : this.parseVariable(string);
        } else {
            throw new ParseException("Expected term.", this.next);
        }
        return object;
    }

    protected AbstractParser.Operation[] nextUnaryOperations() throws ParseException {
        AbstractParser.Operation operation;
        Vector<AbstractParser.Operation> vector = new Vector<AbstractParser.Operation>();
        while ((operation = this.nextOperation()) != null) {
            if (operation.isUnary()) {
                vector.add(operation);
                continue;
            }
            throw new ParseException("Expected unary operation.", this.next);
        }
        return vector.toArray(new AbstractParser.Operation[0]);
    }

    protected Object parseNestedExpression() throws ParseException {
        Object object = null;
        if (this.nextTokenIs(this.NESTED_EXPRESSION_START)) {
            ++this.next;
            AbstractParser.ObjectOperationPair objectOperationPair = this.parseExpression(new AbstractParser.ObjectOperationPair(null, this.identity));
            object = objectOperationPair.value;
            this.skipWhitespace();
            if (this.next == this.data.length() || !this.nextTokenIs(this.NESTED_EXPRESSION_END)) {
                throw new ParseException("Expected end of nested expression.", this.next);
            }
            ++this.next;
        }
        return object;
    }

    protected Object parseProcedureCall(String string) throws ParseException {
        if (!this.procedures.containsKey(string)) {
            throw new ParseException("Unrecognized procedure " + string + ".", this.next);
        }
        AbstractParser.Procedure procedure = (AbstractParser.Procedure)this.procedures.get(string);
        Object object = null;
        try {
            object = procedure.procedureCall(this.parseArgumentList());
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage(), this.next);
        }
        return object;
    }

    protected Object parseVariable(String string) throws ParseException {
        if (!this.environment.containsKey(string)) {
            throw new ParseException("Unrecognized identifier.", this.next);
        }
        return this.environment.get(string);
    }

    public static class BooleanOperation
    extends AbstractParser.Operation {
        public boolean booleanOrNumeric = true;

        public BooleanOperation() {
        }

        public BooleanOperation(String string) {
            super(string);
        }

        public BooleanOperation(String string, boolean bl, boolean bl2) {
            super(string, bl, bl2);
        }

        public BooleanOperation(String string, boolean bl, boolean bl2, boolean bl3) {
            super(string, bl, bl2);
            this.booleanOrNumeric = bl3;
        }

        public final Object performOperation(Object object, Object object2) throws ParseException {
            if (object == null) {
                this.checkUnary();
                if (ParserUtilities.isXBoolean(object2)) {
                    XBoolean xBoolean = (XBoolean)object2;
                    return this.unaryForXBoolean(xBoolean);
                }
                if (!this.booleanOrNumeric) {
                    throw new ParseException("Boolean operation " + this.symbol + " expects 1 boolean argument.", 0);
                }
                if (ParserUtilities.isXIntegral(object2)) {
                    XBigInteger xBigInteger = ParserUtilities.toXBigInteger((XNumber)object2);
                    return this.unaryForXIntegral(xBigInteger);
                }
                if (ParserUtilities.isXNumber(object2)) {
                    XDouble xDouble = ParserUtilities.toXDouble((XNumber)object2);
                    return this.unaryForXFloating(xDouble);
                }
                throw new ParseException("Boolean operation " + this.symbol + " expects 1 boolean or 1 numeric argument.", 0);
            }
            this.checkBinary();
            if (ParserUtilities.isXBoolean(object) && ParserUtilities.isXBoolean(object2)) {
                XBoolean xBoolean = (XBoolean)object;
                XBoolean xBoolean2 = (XBoolean)object2;
                return this.binaryForXBoolean(xBoolean, xBoolean2);
            }
            if (!this.booleanOrNumeric) {
                throw new ParseException("Boolean operation " + this.symbol + " expects 2 boolean arguments.", 0);
            }
            if (ParserUtilities.isXIntegral(object) && ParserUtilities.isXIntegral(object2)) {
                XBigInteger xBigInteger = ParserUtilities.toXBigInteger((XNumber)object);
                XBigInteger xBigInteger2 = ParserUtilities.toXBigInteger((XNumber)object2);
                return this.binaryForXIntegral(xBigInteger, xBigInteger2);
            }
            if (ParserUtilities.isXNumber(object) && ParserUtilities.isXNumber(object2)) {
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)object);
                XDouble xDouble2 = ParserUtilities.toXDouble((XNumber)object2);
                return this.binaryForXFloating(xDouble, xDouble2);
            }
            throw new ParseException("Boolean operation " + this.symbol + " expects 2 boolean or 2 numeric arguments.", 0);
        }

        public Object unaryForXBoolean(XBoolean xBoolean) {
            return null;
        }

        public Object binaryForXBoolean(XBoolean xBoolean, XBoolean xBoolean2) {
            return null;
        }

        public Object unaryForXIntegral(XBigInteger xBigInteger) {
            return null;
        }

        public Object binaryForXIntegral(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
            return null;
        }

        public Object unaryForXFloating(XDouble xDouble) {
            return null;
        }

        public Object binaryForXFloating(XDouble xDouble, XDouble xDouble2) {
            return null;
        }
    }

    public static class NumericOperation
    extends AbstractParser.Operation {
        public NumericOperation() {
        }

        public NumericOperation(String string) {
            super(string);
        }

        public NumericOperation(String string, boolean bl, boolean bl2) {
            super(string, bl, bl2);
        }

        public final Object performOperation(Object object, Object object2) throws ParseException {
            if (object == null) {
                this.checkUnary();
                if (ParserUtilities.isXIntegral(object2)) {
                    XBigInteger xBigInteger = ParserUtilities.toXBigInteger((XNumber)object2);
                    return this.unaryForXIntegral(xBigInteger);
                }
                if (ParserUtilities.isXNumber(object2)) {
                    XDouble xDouble = ParserUtilities.toXDouble((XNumber)object2);
                    return this.unaryForXFloating(xDouble);
                }
                throw new ParseException("Numeric operation " + this.symbol + " expects 1 numeric argument.", 0);
            }
            this.checkBinary();
            if (ParserUtilities.isXIntegral(object) && ParserUtilities.isXIntegral(object2)) {
                XBigInteger xBigInteger = ParserUtilities.toXBigInteger((XNumber)object);
                XBigInteger xBigInteger2 = ParserUtilities.toXBigInteger((XNumber)object2);
                return this.binaryForXIntegral(xBigInteger, xBigInteger2);
            }
            if (ParserUtilities.isXNumber(object) && ParserUtilities.isXNumber(object2)) {
                XDouble xDouble = ParserUtilities.toXDouble((XNumber)object);
                XDouble xDouble2 = ParserUtilities.toXDouble((XNumber)object2);
                return this.binaryForXFloating(xDouble, xDouble2);
            }
            throw new ParseException("Numeric operation " + this.symbol + " expects 2 numeric arguments.", 0);
        }

        public Object unaryForXIntegral(XBigInteger xBigInteger) {
            return null;
        }

        public Object binaryForXIntegral(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
            return null;
        }

        public Object unaryForXFloating(XDouble xDouble) {
            return null;
        }

        public Object binaryForXFloating(XDouble xDouble, XDouble xDouble2) {
            return null;
        }
    }
}

