/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import edu.neu.ccs.XObject;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class XLong
extends XNumber {
    private long value = 0L;

    public XLong() {
    }

    public XLong(long l) {
        this.value = l;
    }

    public XLong(String string) throws ParseException {
        this.fromStringData(string);
    }

    public void fromStringData(String string) throws ParseException {
        long l = this.value;
        Parser parser = ParserUtilities.getDefaultParser();
        Object object = parser.parse(string);
        if (!(object instanceof XNumber)) {
            throw new ParseException("Expected numeric value.", string.length());
        }
        XNumber xNumber = (XNumber)object;
        this.value = xNumber.longValue();
        this.changeAdapter.firePropertyChange("value", new Long(l), string);
    }

    public String toStringData() {
        return this.value + "";
    }

    public byte byteValue() {
        if (this.getValue() > 127L || this.getValue() < -128L) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue();
    }

    public short shortValue() {
        if (this.getValue() > 32767L || this.getValue() < -32768L) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue();
    }

    public int intValue() {
        if (this.getValue() > Integer.MAX_VALUE || this.getValue() < Integer.MIN_VALUE) {
            throw new NumberFormatException("Number beyond precision of a int.");
        }
        return (int)this.getValue();
    }

    public long longValue() {
        return this.getValue();
    }

    public float floatValue() {
        return this.getValue();
    }

    public double doubleValue() {
        return this.getValue();
    }

    public boolean equals(Object object) {
        if (object instanceof XLong) {
            return this.getValue() == ((XLong)object).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Long(this.getValue()).hashCode();
    }

    public String toString() {
        return this.value + "";
    }

    public void setValue(long l) {
        long l2 = this.value;
        this.value = l;
        if (this.getValue() != l2) {
            this.changeAdapter.firePropertyChange("value", new Long(l2), new Long(this.getValue()));
        }
    }

    public long getValue() {
        return this.value;
    }

    public static long parseLong(String string) throws NumberFormatException {
        try {
            return new XLong((String)string).value;
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(XObject.formatErrorMessage(parseException, string));
        }
    }

    public static long[] toPrimitiveArray(XLong[] xLongArray) {
        if (xLongArray == null) {
            return null;
        }
        long[] lArray = new long[xLongArray.length];
        int n = 0;
        while (n < lArray.length) {
            if (xLongArray[n] != null) {
                lArray[n] = xLongArray[n].getValue();
            }
            ++n;
        }
        return lArray;
    }

    public static XLong[] toXArray(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        XLong[] xLongArray = new XLong[lArray.length];
        int n = 0;
        while (n < xLongArray.length) {
            xLongArray[n] = new XLong(lArray[n]);
            ++n;
        }
        return xLongArray;
    }
}

