/*
 * @(#)City.java  1.0  16 April 2003
 *
 * @author Viera K. Proulx
 */

import edu.neu.ccs.gui.*;	// to get BufferedPanel
import edu.neu.ccs.*;	    // to get XInt
import java.util.*;         // to get StringTokenizer
import java.text.*;         // to get ParseException

/** Represents a city with zip code and location */
class City implements Stringable{
    
    /*-------------------------------------------------------------------------
     * Member data 
     *-----------------------------------------------------------------------*/
    
    /** The zip code for this city. */
    public int zip;
    
    /** The name of this city. */
    public String name;
    
    /** The state for this city */
    public String state;
    
    /** The longitude of the city, in degrees west */
    double longitude;
    
    /** The latitude of the city, in degrees north */
    double latitude;

    /* Decimal format to print leading zeros in zip code */
    public DecimalFormat zipFormat = new DecimalFormat("00000");
    
    /*-------------------------------------------------------------------------
     Constructor
     *-----------------------------------------------------------------------*/
    
    /* full constructor */
    public City (int zip, String name, String state, 
		 double longitude, double latitude){
        this.zip   = zip;
        this.name  = name;
        this.state = state;
	this.longitude = longitude;
	this.latitude = latitude;
    }
    
    /** copy constructor */
    public City(City aCity){
        this(aCity.zip, aCity.name, aCity.state, 
	     aCity.longitude, aCity.latitude);
    }
    
    public City (String zip, String name, String state, 
		 double longitude, double latitude) {
        this(decimal(zip), name, state, longitude, latitude);
    }

    public City() {}
    
    /*-------------------------------------------------------------------------
     Methods 
     *-----------------------------------------------------------------------*/
        
    /** determine whether this city is in the given state */
    boolean isInState(String aState){
        return state.equals(aState);
    }

    /** determine whether this city is extensionally equal to another object */
    public boolean equals(Object obj) {
	if (obj instanceof City) {
	    City c = (City)obj;
	    return this.zip == c.zip &&
		this.name.equals(c.name) &&
		this.state.equals(c.state) &&
		this.longitude == c.longitude &&
		this.latitude == c.latitude;
	} else {
	    return false;
	}
    }
    
    /*-------------------------------------------------------------------------
     Stringable interface
     *-----------------------------------------------------------------------*/
    /** city data to string for file output*/
    public String toStringData(){
    	String s = zipFormat.format(this.zip) + ", " +
	    this.name  + ", " +
	    this.state + ", " +
	    this.longitude + ", " + 
	    this.latitude + "\n";
    	return s;
    }
    
    /** string to city data */
    public void fromStringData(String s) throws java.text.ParseException{
	
        try{
            /** set up the string tokenizer to extract city data */
            StringTokenizer st = new StringTokenizer(s, ",");

            this.zip   = decimal(st.nextToken());
            this.name  = st.nextToken();
            this.state = st.nextToken();
	    this.longitude = doubleValue(st.nextToken());
            this.latitude  = doubleValue(st.nextToken());
        }
        catch(NoSuchElementException e){
            System.out.println(e.getMessage());
            throw new java.text.ParseException("Tokenizer Error", 0);
        }
    }
    
    /** convert a String to int - if possible */
    protected static int intValue(String s) throws ParseException{
        return (new XInt(s)).intValue();
    }

    protected static double doubleValue(String s) {
	try {
	    return Double.parseDouble(s);
	} catch (NumberFormatException nfe) {
	    throw new RuntimeException("bad double format");
	}
    }
    
    /*-------------------------------------------------------------------------
     Console print
     *-----------------------------------------------------------------------*/
    /** print the city data */
    public String toString(){
    	return ("new " + getClass() + "(" + 
    	        zipFormat.format(this.zip)   + ",   " + 
    	        this.name  + ",  " + 
    	        this.state + ", " + 
    	        this.longitude + ", " + 
		this.latitude + ")\n");
    }
    
    /** helper method to convert zip code string to integer */
    public static int decimal(String s){
	
    	char[] c = s.toCharArray();
    	int n = 0;
    	try {
	    for (int i = 0; i < 5; i++){
    		n = 10 * n + intValue("" + c[i]);
	    }
    	}
    	catch(ParseException e){
	    System.out.println("Converting zip to int " + e);
    	}
    	return n;
    }
    
}
