/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.jpf;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.gui.ActionsPanel;
import edu.neu.ccs.gui.BufferedPanel;
import edu.neu.ccs.gui.CenterLayout;
import edu.neu.ccs.gui.Display;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TableLayout;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.ThreadedAction;
import edu.neu.ccs.jpf.JPF;
import edu.neu.ccs.jpf.MethodGUI;
import edu.neu.ccs.util.JPTConstants;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.JRootPane;

class JPFApplication
extends DisplayPanel
implements JPTConstants,
ConsoleAware {
    public static final int BUFFER_WIDTH = 400;
    public static final int BUFFER_HEIGHT = 400;
    protected BufferedPanel window = new BufferedPanel(400, 400);
    protected JPF initializer = null;
    protected Class initializerClass = null;
    protected JPTFrame frame = null;
    protected String frameTitle = null;
    protected boolean showGraphicsWindow = true;
    protected final int MAXIMUM_ROWS = 25;
    protected ActionsPanel buttons = new ActionsPanel(new TableLayout(25, 1, 0, 0, 0, 0));
    protected DisplayPanel LHS = null;
    protected DisplayPanel RHS = null;
    protected TablePanel mainPanel = null;
    protected Action clearGraphics = new SimpleAction("Clear Graphics"){

        public void perform() {
            JPFApplication.this.clearGraphics();
        }
    };
    protected Action toggleGraphics = new SimpleAction("Toggle Graphics"){

        public void perform() {
            JPFApplication.this.toggleGraphics();
        }
    };
    protected Action exitFramework = new SimpleAction("Exit"){

        public void perform() {
            JPFApplication.this.exitFramework();
        }
    };
    static /* synthetic */ Class class$edu$neu$ccs$jpf$JPF;
    static /* synthetic */ Class class$edu$neu$ccs$Stringable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$awt$geom$Point2D$Double;

    public JPFApplication(JPF jPF, String string) {
        if (jPF == null) {
            return;
        }
        this.initializer = jPF;
        this.initializerClass = jPF.getClass();
        this.setFrameTitle(string);
        this.buildButtons();
        this.buildGUI();
        this.frame = JPTFrame.createQuickJPTFrame(this.getFrameTitle(), this, new CenterLayout(), 2);
    }

    public BufferedPanel getGraphicsWindow() {
        return this.window;
    }

    public String getFrameTitle() {
        return this.frameTitle;
    }

    public void setFrameTitle(String string) {
        String string2 = this.frameTitle = string != null && !string.equals("") ? string : JPFApplication.className(this.initializerClass);
        if (this.frame != null) {
            this.frame.setTitle(this.frameTitle);
        }
    }

    protected void buildButtons() {
        Method[] methodArray = this.getMethodList();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (methodArray[n2] != null) {
                this.addOneButton(this.makeActionFromMethod(methodArray[n2]), this.getMethodToolTip(methodArray[n2]));
            }
            ++n2;
        }
        this.addOneButton(this.clearGraphics, "Clear the Graphics Window");
        this.addOneButton(this.toggleGraphics, "Show or Hide the Graphics Window");
        this.addOneButton(this.exitFramework, "Exit the Framework");
        this.buttons.uniformizeSize();
    }

    protected void clearGraphics() {
        this.window.clearPanel();
        this.window.repaint();
    }

    protected void toggleGraphics() {
        if (this.showGraphicsWindow) {
            this.mainPanel.remove(this.RHS);
        } else {
            this.mainPanel.add(this.RHS);
        }
        this.showGraphicsWindow = !this.showGraphicsWindow;
        this.frame.pack();
        this.frame.setLocation(2);
    }

    protected void exitFramework() {
        ConsoleAware.console.setActivated(false);
        System.exit(0);
    }

    protected void addOneButton(Action action, String string) {
        this.buttons.addAction(action);
        this.buttons.findMatchedButton(action).setToolTipText(string);
    }

    protected String getMethodToolTip(Method method) {
        if (method == null) {
            return "";
        }
        return (this.isStatic(method) ? "static " : "") + JPFApplication.className(method.getReturnType()) + " " + method.getName() + "(" + this.getParameterNames(method) + ")" + " in " + JPFApplication.className(method.getDeclaringClass());
    }

    protected String getParameterNames(Method method) {
        String string = "";
        if (method == null) {
            return string;
        }
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        if (n == 0) {
            return string;
        }
        string = JPFApplication.className(classArray[0]);
        int n2 = 1;
        while (n2 < n) {
            string = string + ", " + JPFApplication.className(classArray[n2]);
            ++n2;
        }
        return string;
    }

    protected void buildGUI() {
        this.showConsole();
        this.LHS = new Display(this.buttons, null, "Tasks");
        this.RHS = new Display(this.window, null, "Graphics");
        this.mainPanel = new TablePanel(new Object[]{this.LHS, this.RHS}, 0, 5, 5, 1);
        this.add(this.mainPanel);
    }

    protected void showConsole() {
        ConsoleAware.console.setActivated(true);
        ConsoleAware.console.selectColorTextScheme();
    }

    protected Method[] getMethodList() {
        Method[] methodArray = this.getExtraMethods(this.initializerClass, class$edu$neu$ccs$jpf$JPF == null ? (class$edu$neu$ccs$jpf$JPF = JPFApplication.class$("edu.neu.ccs.jpf.JPF")) : class$edu$neu$ccs$jpf$JPF);
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!this.isSimpleMethod(methodArray[n2]) && !this.isGUIMethod(methodArray[n2])) {
                methodArray[n2] = null;
            }
            ++n2;
        }
        this.removeDuplicateVirtualMethods(methodArray);
        return methodArray;
    }

    protected void removeDuplicateVirtualMethods(Method[] methodArray) {
        if (methodArray == null) {
            return;
        }
        int n = methodArray.length;
        int n2 = n - 1;
        while (n2 > 0) {
            if (methodArray[n2] != null && !this.isStatic(methodArray[n2])) {
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    if (methodArray[n3] != null && !this.isStatic(methodArray[n3]) && this.isDuplicate(methodArray[n2], methodArray[n3])) {
                        methodArray[n3] = null;
                    }
                    --n3;
                }
            }
            --n2;
        }
    }

    protected boolean isDuplicate(Method method, Method method2) {
        if (method == null || method2 == null) {
            return false;
        }
        return method.getName().equals(method2.getName()) && method.getModifiers() == method2.getModifiers() && method2.getReturnType() == method2.getReturnType() && this.isDuplicateParameterList(method, method2);
    }

    protected boolean isDuplicateParameterList(Method method, Method method2) {
        Class<?>[] classArray;
        int n;
        if (method == null || method2 == null) {
            return false;
        }
        Class<?>[] classArray2 = method.getParameterTypes();
        int n2 = classArray2.length;
        if (n2 != (n = (classArray = method2.getParameterTypes()).length)) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (classArray2[n3] != classArray[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected Action makeActionFromMethod(final Method method) {
        if (method == null) {
            return null;
        }
        String string = this.isStatic(method) ? JPFApplication.className(method.getDeclaringClass()) + "." + method.getName() : method.getName();
        return new ThreadedAction(new SimpleAction(string){

            public void perform() {
                JPFApplication.this.performAction(method);
            }
        });
    }

    protected synchronized void performAction(Method method) {
        block4: {
            String string = method.getName();
            try {
                if (this.isGUIMethod(method)) {
                    this.performActionUsingGUI(method);
                    break block4;
                }
                if (this.isStatic(method)) {
                    method.invoke(null, null);
                    break block4;
                }
                method.invoke((Object)this.initializer, null);
            }
            catch (Exception exception) {
                this.handleMethodException(exception, string);
            }
        }
    }

    protected void handleMethodException(Throwable throwable, String string) {
        if (throwable instanceof IllegalAccessException) {
            IllegalAccessException illegalAccessException = (IllegalAccessException)throwable;
            ConsoleAware.console.err.print("JPF Error: IllegalAccessException: ");
            ConsoleAware.console.err.println(illegalAccessException + "\n");
        } else if (throwable instanceof IllegalArgumentException) {
            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
            ConsoleAware.console.err.print("JPF Error: IllegalArgumentException: ");
            ConsoleAware.console.err.println(illegalArgumentException + "\n");
        } else if (throwable instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
            throwable = invocationTargetException.getTargetException();
        }
        this.printExceptionTrace(throwable, string);
    }

    protected void printExceptionTrace(Throwable throwable, String string) {
        ConsoleAware.console.err.println("Exception: " + throwable + "\nIn: " + string + "\n");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        String string2 = stringWriter.toString();
        int n = string2.indexOf(".reflect.");
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.lastIndexOf("\n")) >= 0) {
            string2 = string2.substring(0, n);
        }
        if (string2.length() > 0) {
            ConsoleAware.console.err.println(string2 + "\n");
        }
    }

    public synchronized void performActionUsingGUI(Method method) {
        String string = method.getName() + " evaluator";
        MethodGUI methodGUI = new MethodGUI(this, method);
        JPTFrame jPTFrame = JPTFrame.createQuickJPTFrame(string, methodGUI, new CenterLayout(), 0);
        JRootPane jRootPane = methodGUI.getRootPane();
        if (jRootPane != null) {
            jRootPane.setDefaultButton(methodGUI.evaluateButton);
        }
    }

    protected boolean isSimpleMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getName().equals("main")) {
            return false;
        }
        if (method.getReturnType() != Void.TYPE) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        int n = method.getModifiers();
        return (n & 1) != 0;
    }

    protected boolean isGUIMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getName().equals("main")) {
            return false;
        }
        if (!this.isAcceptableMethodForGUI(method)) {
            return false;
        }
        int n = method.getModifiers();
        return (n & 1) != 0;
    }

    protected boolean isAcceptableTypeForGUI(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return true;
        }
        if ((class$edu$neu$ccs$Stringable == null ? (class$edu$neu$ccs$Stringable = JPFApplication.class$("edu.neu.ccs.Stringable")) : class$edu$neu$ccs$Stringable).isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = JPFApplication.class$("java.lang.String")) : class$java$lang$String)) {
            return true;
        }
        if (clazz.equals(class$java$awt$Color == null ? (class$java$awt$Color = JPFApplication.class$("java.awt.Color")) : class$java$awt$Color)) {
            return true;
        }
        if (clazz.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = JPFApplication.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return true;
        }
        if (clazz.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JPFApplication.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return true;
        }
        return clazz.equals(class$java$awt$geom$Point2D$Double == null ? (class$java$awt$geom$Point2D$Double = JPFApplication.class$("java.awt.geom.Point2D$Double")) : class$java$awt$geom$Point2D$Double);
    }

    protected boolean isAcceptableMethodForGUI(Method method) {
        if (method == null) {
            return false;
        }
        Class<?> clazz = method.getReturnType();
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        if (clazz.equals(Void.TYPE) && n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!this.isAcceptableTypeForGUI(classArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected Method[] getExtraMethods(Class clazz, Class clazz2) {
        if (clazz == null || clazz.equals(clazz2) || clazz.isPrimitive() || clazz.isInterface() || clazz.isArray()) {
            return new Method[0];
        }
        return this.joinMethodArrays(this.getExtraMethods(clazz.getSuperclass(), clazz2), clazz.getDeclaredMethods());
    }

    protected Method[] joinMethodArrays(Method[] methodArray, Method[] methodArray2) {
        int n = methodArray.length;
        int n2 = methodArray2.length;
        int n3 = n + n2;
        Method[] methodArray3 = new Method[n3];
        int n4 = 0;
        while (n4 < n) {
            methodArray3[n4] = methodArray[n4];
            ++n4;
        }
        int n5 = n;
        while (n5 < n3) {
            methodArray3[n5] = methodArray2[n5 - n];
            ++n5;
        }
        return methodArray3;
    }

    protected boolean isStatic(Method method) {
        if (method == null) {
            return false;
        }
        int n = method.getModifiers();
        return (n & 8) != 0;
    }

    protected static String className(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

