/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern:
        iterator for console input of a list of cities 
*/

import edu.neu.ccs.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.util.*;

import java.io.*;
import java.awt.*;

class InConsoleRange implements IRange, ConsoleAware {

    /*-------------------------------------------------------- 
     Member data
     *------------------------------------------------------*/
    protected City c;
    
    protected boolean done = true;
    protected boolean submitted = false;
       
    /*-------------------------------------------------------- 
     Constructor
     *------------------------------------------------------*/
    InConsoleRange() { 

        done = false;
        read();          
    }
        
    /*--------------------------------------------------------
     Methods to implement the IRange interface
     *------------------------------------------------------*/

    public void next() {
        read();            
    }


    public Object current() {
       return c;
    }
    
    public boolean hasMore() {
        return (!done); 
    }
    
    /*--------------------------------------------------------------
     Methods
     *------------------------------------------------------------*/

    /* read data for one balloon from the console */
    public City read(){
        
        try{
          c = new City
            (requestInt("Zip code: "),
             requestString("City name: "),
             requestString("State: "),
             requestInt("Area code: "));
        }
        catch(IOException e){
            console.out.println(e.getMessage());
        }
        return c;
    }
    
    
    /* request one integer from the console */
    public int requestInt(String s) throws IOException{

        XInt temp = new XInt(0);
        boolean more = console.in.reading(s, (Stringable)temp);
        if (more)
            return temp.intValue();
        else
            done = true;
            throw(new IOException("End of input."));
    }
    
    /* request one String from the console */
    public String requestString(String s) throws IOException{

        XString temp = new XString("");
        boolean more = console.in.reading(s, (Stringable)temp);
        if (more)
            return temp.getValue();
        else
            done = true;
            throw(new IOException("End of input."));
    }
    
}
        
