/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XString;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Fragile;
import edu.neu.ccs.gui.InputProperties;
import edu.neu.ccs.gui.MalformedDataEvent;
import edu.neu.ccs.gui.MalformedDataListener;
import edu.neu.ccs.gui.TextFieldView;
import edu.neu.ccs.gui.TypedView;
import edu.neu.ccs.util.JPTUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileView
extends DisplayPanel
implements TypedView,
Fragile {
    public static final String LAST_PATH = "last.path";
    public static final String DEFAULT_FILENAME = "";
    public static final String DEFAULT_BUTTON_LABEL = "Browse";
    public static final int DEFAULT_ALIGNMENT = 4;
    protected static final FileFilter ALL_FILES_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return "All files (*.*)";
        }
    };
    protected static String lastPath = null;
    protected int align = 4;
    protected TextFieldView field = null;
    protected JButton browse = null;
    protected InputProperties properties = new InputProperties();
    static /* synthetic */ Class class$edu$neu$ccs$XString;
    static /* synthetic */ Class class$edu$neu$ccs$gui$MalformedDataListener;

    public FileView() {
        this(DEFAULT_FILENAME, 4);
    }

    public FileView(String string) {
        this(string, 4);
    }

    public FileView(String string, int n) {
        try {
            lastPath = System.getProperty("user.dir");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.field = new TextFieldView(string);
        this.field.setPreferredWidth(100);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.field, "Center");
        this.setAlignment(n);
        this.addMalformedDataListener(this);
    }

    public Stringable demandObject() {
        return new XString(this.getViewState());
    }

    public Stringable requestObject() throws CancelledException {
        return this.demandObject();
    }

    public void setInputProperties(InputProperties inputProperties) {
        if (inputProperties == null) {
            inputProperties = InputProperties.BASE_PROPERTIES;
        }
        InputProperties inputProperties2 = this.getInputProperties();
        this.properties = inputProperties;
        if (this.getInputProperties() != null && !this.getInputProperties().equals(inputProperties2)) {
            this.firePropertyChange("input.properties", inputProperties2, this.getInputProperties());
        }
    }

    public InputProperties getInputProperties() {
        return this.properties;
    }

    public Class getDataType() {
        return class$edu$neu$ccs$XString == null ? (class$edu$neu$ccs$XString = FileView.class$("edu.neu.ccs.XString")) : class$edu$neu$ccs$XString;
    }

    public void setViewState(String string) {
        this.field.setViewState(string);
        this.firePropertyChange("view.state", null, string);
    }

    public String getViewState() {
        return this.field.getViewState();
    }

    public void setDefaultViewState(String string) {
        this.field.setDefaultViewState(string);
        this.firePropertyChange("default.view.state", null, string);
    }

    public String getDefaultViewState(String string) {
        return this.field.getDefaultViewState();
    }

    public void reset() {
        this.field.reset();
    }

    public void setEnabled(boolean bl) {
        this.field.setEnabled(bl);
        this.browse.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void addMalformedDataListener(MalformedDataListener malformedDataListener) {
        this.listenerList.add(class$edu$neu$ccs$gui$MalformedDataListener == null ? (class$edu$neu$ccs$gui$MalformedDataListener = FileView.class$("edu.neu.ccs.gui.MalformedDataListener")) : class$edu$neu$ccs$gui$MalformedDataListener, malformedDataListener);
    }

    public void removeMalformedDataListener(MalformedDataListener malformedDataListener) {
        this.listenerList.remove(class$edu$neu$ccs$gui$MalformedDataListener == null ? (class$edu$neu$ccs$gui$MalformedDataListener = FileView.class$("edu.neu.ccs.gui.MalformedDataListener")) : class$edu$neu$ccs$gui$MalformedDataListener, malformedDataListener);
    }

    public File demandExistingFile() {
        return new File(this.demandExistingFilename());
    }

    public File demandFile() {
        return new File(this.demandFilename());
    }

    public String demandExistingFilename() {
        try {
            return this.performRequest(false, true);
        }
        catch (CancelledException cancelledException) {
            return null;
        }
    }

    public String demandFilename() {
        try {
            return this.performRequest(true, true);
        }
        catch (CancelledException cancelledException) {
            return null;
        }
    }

    public File requestExistingFile() throws CancelledException {
        return new File(this.requestExistingFilename());
    }

    public File requestFile() throws CancelledException {
        return new File(this.requestFilename());
    }

    public String requestExistingFilename() throws CancelledException {
        return this.performRequest(false, false);
    }

    public String requestFilename() throws CancelledException {
        return this.performRequest(true, false);
    }

    public void setAlignment(int n) {
        int n2 = this.getAlignment();
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.align = n;
                break;
            }
            case -1: {
                this.align = 4;
                break;
            }
            default: {
                return;
            }
        }
        if (this.browse == null) {
            this.browse = new JButton(DEFAULT_BUTTON_LABEL);
            this.browse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser(FileView.this.getLastPath());
                    jFileChooser.setFileFilter(ALL_FILES_FILTER);
                    if (jFileChooser.showOpenDialog(null) == 0) {
                        FileView.this.setViewState(jFileChooser.getSelectedFile().getPath());
                        FileView.this.setLastPath(jFileChooser.getSelectedFile().getPath());
                    }
                }
            });
        } else {
            this.remove(this.browse);
        }
        this.add((Component)this.browse, JPTUtilities.getBorderLayoutLocation(n));
        if (this.getAlignment() != n2) {
            this.firePropertyChange("alignment", n2, this.getAlignment());
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setLastPath(String string) {
        String string2 = this.getLastPath();
        lastPath = string;
        if (this.getLastPath() != null && !this.getLastPath().equals(string2)) {
            this.firePropertyChange(LAST_PATH, string2, this.getLastPath());
        }
    }

    public String getLastPath() {
        return lastPath;
    }

    protected JButton getBrowseButton() {
        return this.browse;
    }

    protected void fireDataMalformed(MalformedDataEvent malformedDataEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] != null && objectArray[n].equals(class$edu$neu$ccs$gui$MalformedDataListener == null ? FileView.class$("edu.neu.ccs.gui.MalformedDataListener") : class$edu$neu$ccs$gui$MalformedDataListener)) {
                MalformedDataListener malformedDataListener = (MalformedDataListener)objectArray[n];
                malformedDataListener.dataMalformed(malformedDataEvent);
            }
            n -= 2;
        }
    }

    protected String performRequest(boolean bl, boolean bl2) throws CancelledException {
        boolean bl3 = false;
        File file = new File(this.field.getViewState());
        JFileChooser jFileChooser = null;
        while (!file.exists()) {
            int n;
            try {
                if (bl && file.createNewFile()) {
                    file.delete();
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!bl3) {
                bl3 = true;
                this.fireDataMalformed(new MalformedDataEvent(this, this.field.getViewState(), new ParseException("Path/filename is not valid.", -1)));
            }
            if (jFileChooser == null) {
                jFileChooser = new JFileChooser(file);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setFileFilter(ALL_FILES_FILTER);
            }
            if ((n = jFileChooser.showDialog(this, "Select")) == 0) {
                file = jFileChooser.getSelectedFile();
                this.field.setViewState(file.getPath());
                this.setLastPath(file.getPath());
                continue;
            }
            if (n == 1 && !bl2) {
                if (bl3) {
                    this.fireDataMalformed(new MalformedDataEvent((Object)this, null));
                }
                throw new CancelledException();
            }
            jFileChooser.setSelectedFile(file);
        }
        if (bl3) {
            this.fireDataMalformed(new MalformedDataEvent((Object)this, this.field.getViewState()));
        }
        return this.field.getViewState();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ExtensionFileFilter
    extends FileFilter
    implements Cloneable,
    Serializable {
        private String ext = null;

        public ExtensionFileFilter(String string) {
            this.ext = string.toUpperCase();
        }

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            if (this.ext == null || this.ext.length() == 0) {
                return true;
            }
            return file.getName().toUpperCase().endsWith(this.ext);
        }

        public String getDescription() {
            if (this.ext == null) {
                return "All files: *.*";
            }
            return this.ext + " files: *." + this.ext.toLowerCase();
        }
    }
}

