 * @(#)ChFileReadBalloon.java  23 March 2003
 *
 * @author Viera K. Proulx
 */

import java.awt.*;

/** An input channel to return Balloon object from GUI input. */
class ChFileReadBalloon implements ChBalloonInput{
    
    /*--------------------------------------------------------------
     Member data
     *------------------------------------------------------------*/

    public Balloon read();

    
    /*
     * saveToFile action
     *
     * save the history panel content to a file
     */
    
    public void saveToFile() {
        // disable all actions and choices during the file choice
        controls.setEnabled(false);       
        window.setEnabled(false);  
                      
        // build a file chooser and have the user choose a file,
        // quitting this operation if the user cancelled the choice
        JFileChooser chooser = new JFileChooser(".");
        
        // set the file extension to be .paint
        chooser.setFileFilter(new FileView.ExtensionFileFilter("paint"));
        
        // see if file was selected - quit if user canceled
        if (chooser.showSaveDialog(null) != JFileChooser.APPROVE_OPTION) {
            controls.setEnabled(true);       
            window.setEnabled(true);        
                            
            return;
        }
        
        // write to the selected file
        try{
            FileUtilities.writeFile(
            	chooser.getSelectedFile(),	// get the selected file
                history.getViewState(),   	// extract the text to save
                true);                    	// OK to overwrite existing file
            }
        catch(Exception e) {
       	    System.out.println("Exception: " + e);
            }

        // enable the buttons for the next file
        controls.setEnabled(true);       
        window.setEnabled(true);        
      
    }
    
}