/*
 * @(#)BalloonView.java  7 April 2003
 *
 *   Viera Proulx      vkp@ccs.neu.edu
 */

import edu.neu.ccs.*;
import edu.neu.ccs.filter.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.geom.*;
import java.text.NumberFormat;
import java.text.DecimalFormat;
import javax.swing.*;

/**
 * View for input and manipulation of a Balloon object.
 */
public class BalloonView
    implements JPTConstants {
        
    /////////////////
    // Member Data //
    /////////////////
    
    /** Balloon object for reference */    
    protected Balloon b;
    
	/** The view to be used in input GUIs */
	public Display bView = new Display();

    /** Display field for the x coordinate of the center. */
    protected TextFieldView xTFV = 
                new TextFieldView("300",
                        	      "Please enter an integer:",
                        	      "x coordinate error",
                        	      80);

    /** Display field for the y coordinate of the center. */
    protected TextFieldView yTFV = 
                new TextFieldView("200",
                        	      "Please enter an integer:",
                        	      "y coordinate error",
                        	      80);
	             

    /** Display field for the radius of a point. */
    protected TextFieldView rTFV =
                new TextFieldView("40",
                        	      "Please enter an integer:",
                        	      "radius error",
                        	      80);
	             
    /** The view in the GUI that displays the color. */
    protected ColorView cView = new ColorView(Color.red, true);

    /** Two filters to guarantee the input is within given range */
    /*???????????????????????????????????????????????????????????*/
    
    public BalloonView() {
		super();
		
		/* record the infromation about this balloon */
   	    this.b = new Balloon();
   	    
 		// create Display with title "Balloon"
		bView = new Display(createDisplay(), null, "Balloon");
    }
    
    //////////////////////////////////
    // Helpers for the Constructors //
    //////////////////////////////////
    
    /**
     * Construct a table panel display for one balloon, containing
     * three text field views, sliders, and color view
     */
    protected TablePanel createDisplay() {
    	
    	/* set default values for three text field views */
	    xTFV.setDefaultViewState("300");
	    yTFV.setDefaultViewState("200");	    
	    rTFV.setDefaultViewState("40");	
	            
        /* compose the TFVs, and the ColorView into one panel */
        TablePanel balloonDisplay = new TablePanel(new Object[][]{
            {"X", xTFV},
            {"Y", yTFV},
            {"R", rTFV},
            {"Color:", cView}},
            VERTICAL, 5, 5);
        
        return balloonDisplay;        	
    }
    
    /* set the view state from the current state of the balloon */
    public void setViewState(){
        xTFV.setViewState("" + b.x);
        yTFV.setViewState("" + b.y);
        rTFV.setViewState("" + b.radius);
        cView.setColor(b.c);
    }
    
    /* get the Balloon object from this view */
    public Balloon getBalloon(){
        b.x = xTFV.demandInt();
        b.y = 200;
        b.radius = 20;
        b.c = Color.red;
        return b;
    }

}