/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ActionSequence;
import edu.neu.ccs.gui.ComponentActionEvent;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;
import javax.swing.Action;

public class ComponentActionAdapter
implements ComponentListener,
Cloneable,
Serializable {
    protected ActionSequence hiddenActions = new ActionSequence();
    protected ActionSequence movedActions = new ActionSequence();
    protected ActionSequence resizedActions = new ActionSequence();
    protected ActionSequence shownActions = new ActionSequence();

    public ComponentActionAdapter() {
        this(null);
    }

    public ComponentActionAdapter(Component component) {
        if (component == null) {
            return;
        }
        component.addComponentListener(this);
    }

    public final void componentHidden(ComponentEvent componentEvent) {
        this.hiddenActions.actionPerformed(new ComponentActionEvent(componentEvent, componentEvent.getSource()));
    }

    public final void componentMoved(ComponentEvent componentEvent) {
        this.movedActions.actionPerformed(new ComponentActionEvent(componentEvent, componentEvent.getSource()));
    }

    public final void componentResized(ComponentEvent componentEvent) {
        this.resizedActions.actionPerformed(new ComponentActionEvent(componentEvent, componentEvent.getSource()));
    }

    public final void componentShown(ComponentEvent componentEvent) {
        this.shownActions.actionPerformed(new ComponentActionEvent(componentEvent, componentEvent.getSource()));
    }

    public void addComponentHiddenAction(Action action) {
        this.hiddenActions.add(action);
    }

    public void addComponentMovedAction(Action action) {
        this.movedActions.add(action);
    }

    public void addComponentResizedAction(Action action) {
        this.resizedActions.add(action);
    }

    public void addComponentShownAction(Action action) {
        this.shownActions.add(action);
    }

    public void removeComponentHiddenAction(Action action) {
        this.hiddenActions.remove(action);
    }

    public void removeComponentMovedAction(Action action) {
        this.movedActions.remove(action);
    }

    public void removeComponentResizedAction(Action action) {
        this.resizedActions.remove(action);
    }

    public void removeComponentShownAction(Action action) {
        this.shownActions.remove(action);
    }

    public void setComponentHiddenActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.hiddenActions.clear();
        } else {
            this.hiddenActions = actionSequence;
        }
    }

    public void setComponentMovedActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.movedActions.clear();
        } else {
            this.movedActions = actionSequence;
        }
    }

    public void setComponentResizedActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.resizedActions.clear();
        } else {
            this.resizedActions = actionSequence;
        }
    }

    public void setComponentShownActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.shownActions.clear();
        } else {
            this.shownActions = actionSequence;
        }
    }

    public ActionSequence getComponentHiddenActions() {
        return this.hiddenActions;
    }

    public ActionSequence getComponentMovedActions() {
        return this.movedActions;
    }

    public ActionSequence getComponentResizedActions() {
        return this.resizedActions;
    }

    public ActionSequence getComponentShownActions() {
        return this.shownActions;
    }
}

