/* 
TestSuite.java  26 February 2003 */


import java.awt.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.math.*;

public class TestSuite extends JPFalt 
{
    public static void main(String[] args) { new TestSuite(); }
    
    ///////////////////////////////////////////////////////////
    // Place your actual methods here.                       //
    ///////////////////////////////////////////////////////////
    
	/*----------------------------------------------------------------------- 
	 Test Balloons
	------------------------------------------------------------------------- */
    
    void NinetyNineRedBallons() {
    // Create ten balloons
    // Use random number generator to select the center (between 100 and 200)
    // Use random number generator to select the radius (between 10 and 50)
    	
    	int x;								// declare horizontal coordinate
    	int y;								// declare vertical coordinate
    	int radius;							// declare variable for radius
    	
    	Balloon b;
    	    	
    	for (int i = 1; i <= 99; i++){		// count from one to ten
    	
    	    // set value of horizontal coordinate
    		x = MathUtilities.randomInt(0, 400);	
    			
    		// set value of vertical coordinate
    		y = MathUtilities.randomInt(0, 400);		
    		
    		// set value of variable for radius
    		radius = MathUtilities.randomInt(10, 20);
    		
			b = new Balloon(x, y, 
			                radius, 
			                new Color(255, 0, 0));
			b.paintBalloon(window);
			
    	}
    	// post-mortem
    	console.out.println("99 Red Balloons done.");
    }
    
	/*-------------------------------------------------------- 
	 Test Balloon View
	--------------------------------------------------------*/
 
    void TestBalloonView() {
    
        Balloon[] b = new Balloon[4];
        int x;
        int y;
        int radius;
        
        /* make array of four balloons - a bad one */
        b[0] = new Balloon(100, 200, 25, Color.red);
        b[1] = new Balloon(300, 100, 40, Color.blue);
        
        // want another Balloon just like b[0]... but this doesn't make a new Balloon.
       	b[2] = b[0]; 
        	
        b[3] = new Balloon(200, 200, 30, Color.green);
    	 
		makeBalloonView(b);
	}
	
	
	/*----------------------------------------------------------------------- 
	 Arrayed Balloon tests
	------------------------------------------------------------------------- */
	void BalloonArrays(){
	
	    int x;
	    int y;
	    int radius;
	    
	    // Take a look at this code, try to figure out
	    // WHY it is doing what it's doing
        Balloon[] b1 = new Balloon[5];
        Balloon[] b2 = new Balloon[5];
        Balloon[] b3 = new Balloon[5];
        Balloon[] b4 = b1;
	
        for (int i = 0; i < 5; i++){
    	
    	    // set value of horizontal coordinate
    		x = MathUtilities.randomInt(0, 400);	
    			
    		// set value of vertical coordinate
    		y = MathUtilities.randomInt(0, 400);		
    		
    		// set value of variable for radius
    		radius = MathUtilities.randomInt(10, 20);
    		
    		Color c = new Color(MathUtilities.randomInt(0, 255), MathUtilities.randomInt(0, 255), MathUtilities.randomInt(0, 255));
    		
			b1[i] = new Balloon(x, y, radius, c );
			b2[i] = new Balloon( b1[i] );
			b3[i] = b1[i];
			b4[i] = new Balloon(x+5, y, radius, c );
			
			// Now let's do some testing, which of these should be equal?
			// Fill in the expected in each case, do this BEFORE running the program
			/*
			if( !( b1[i].equals(b2[i])== trueorfalse ) )
				actual( "Error with equality check!" );
			if( !( b1[i].equals(b3[i])== trueorfalse ) )
				actual( "Error with equality check!" );
			if( !( b1[i].equals(b4[i])== trueorfalse ) )
				actual( "Error with equality check!" );
			if( !( b2[i].equals(b3[i])== trueorfalse ) )
				actual( "Error with equality check!" );
			if( !( b2[i].equals(b4[i])== trueorfalse ) )
				actual( "Error with equality check!" );
			if( !( b3[i].equals(b4[i])== trueorfalse ) )
				actual( "Error with equality check!" );
			
			if( !( b1[i]==b2[i]== trueorfalse ) )
				actual( "Error with equality check!" );
			if( !( b1[i]==b3[i]== trueorfalse ) )
				actual( "Error with equality check!" );
			if( !( b1[i]==b4[i]== trueorfalse ) )
				actual( "Error with equality check!" );
			if( !( b2[i]==b3[i]== trueorfalse ) )
				actual( "Error with equality check!" );
			if( !( b2[i]==b4[i]== trueorfalse ) )
				actual( "Error with equality check!" );
			if( !( b3[i]==b4[i]== trueorfalse ) )
				actual( "Error with equality check!" );
			*/
		}
		
	}
	
	/*--------------------------------------------------------
	A series of tests of balloon equality
	--------------------------------------------------------*/
	void TestBalloonEqual() {
		Balloon[] b = new Balloon[] {
			new Balloon(10, 20, 30, Color.blue),
			new Balloon(5, 50, 10, Color.red),
			new Balloon(10, 20, 30, Color.blue)
			};
			
		testHeader("-Balloon Equality Tests-");
		
		console.out.println("*Comparing: \n\t" + b[0] + " to\n\t" + b[1]);
		expected(false);
		actual(b[0].equals(b[1]));
		console.out.println();
		
		console.out.println("*Comparing:\n\t" + b[1] + "\n\tto itself");
		expected(true);
		actual(b[1].equals(b[1]));
		console.out.println();
		
		console.out.println("*Comparing:\n\t" + b[0] + " to\n\t" + b[2]);
		expected(true);
		actual(b[0].equals(b[2]));
		console.out.println();
	}

    /* Helper method to install controls for an array of balloons */
    void makeBalloonView(Balloon[] bArray){
     	
        /* install the views in a new table panel */
        GeneralDialog.showOKDialog(new TablePanel(
                                    (new BalloonDialog(bArray, window)).bw,
                                    1, 1,
                                    VERTICAL),
                                  "Balloon Array Controller");
    }
}

