/*
 * @(#)BalloonView.java  1 March 2003
 *
 *   Viera Proulx      vkp@ccs.neu.edu
 */

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.geom.*;
import java.text.NumberFormat;
import java.text.DecimalFormat;
import javax.swing.*;

/**
 * View for input and manipulation of a Balloon object.
 */
public class BalloonView
    extends Display
    implements JPTConstants {
    
    ///////////////
    // Constants //
    ///////////////
    
	/** Default label for the x coordinate text field view */
	public static final String DEFAULT_LABELx = "X:";
    
    /** Default label for the y coordinate text field view */
	public static final String DEFAULT_LABELy = "Y:";
    
    /** Default label for the y coordinate text field view */
	public static final String DEFAULT_LABELr = "R:";
    
    /** Default layout orientation for the Point2DView . */
    public static final int DEFAULT_ORIENTATION = VERTICAL;
    
    /////////////////
    // Member Data //
    /////////////////
    
    /** Balloon number for reference */
    int n;
    
    /** The Balloon array controlled by this GUI */
    Balloon[] bArray;
    Balloon b;
    
    /** The composite display of the whole array of balloons */
    BalloonDialog bd;
    
    /** Display field for the x coordinate of the center. */
    protected TextFieldView xTFV;

    /** Display field for the y coordinate of the center. */
    protected TextFieldView yTFV;

    /** Display field for the radius of a point. */
    protected TextFieldView rTFV;

    /** Property list for this view object. */
    protected InputProperties properties = new InputProperties();
    
    /** The slider in the GUI that controls x value. */
    protected SliderView xSlider;

    /** The slider in the GUI that controls y value. */
    protected SliderView ySlider;

    /** The slider in the GUI that controls radius. */
    protected SliderView rSlider;

    /** The view in the GUI that displays the color. */
    protected ColorView cView;
    
    /** The property change action adapter for the color view. */
    protected PropertyChangeActionAdapter pca = 
        new PropertyChangeActionAdapter(cView);

    /** The graphics panel for the display. */
    protected BufferedPanel window;
    
   	/* default values for the views */
   	int xDefault;
   	int yDefault;
   	int rDefault;
   	Color cDefault = Color.red;
   	    
   	    
    /** 
     * Action triggering the task of setting the current color
     * to the color represented by input in the text field.
     */
    protected Action setValueFromField =
        new SimpleAction("Set Value") {
            public void perform() { 
                setValueFromField(); 
            }
        };
    
    
    public BalloonView(int n, Balloon[] balloons, BalloonDialog abd, BufferedPanel window) {
		super();
		
		/* record the infromation about this balloon and the whole array */
		this.bd = abd;
   	    this.n = n;
   	    this.bArray = balloons;
   	    this.b = balloons[n];
   	    
   	    /* the graphics panel for painting */
   	    this.window = window;
   	    
   	    /* defaults for the views */
   	    this.xDefault = b.getX();
   	    this.yDefault = b.getY();
   	    this.rDefault = b.getRadius();
   	    this.cDefault = b.getColor();
		
		// add the internal panel to the Display
		add(createDisplay
		    (this.xDefault, this.yDefault, this.rDefault, this.cDefault,
		     DEFAULT_LABELx, DEFAULT_LABELy, DEFAULT_LABELr));
		
		// set the title and annotation for the Display
		setTitleText("Balloon " + n);
    }
    
    //////////////////////////////////
    // Helpers for the Constructors //
    //////////////////////////////////
    
    /**
     * Construct a table panel display for one balloon, containing
     * three text field views, sliders, and color view
     */
    protected TablePanel createDisplay(
       	int xDefault,
       	int yDefault,
       	int rDefault,
       	Color cDefault,
    	String labelX,
    	String labelY,
    	String labelR) {
    	
        createTFVTriple(xDefault, yDefault, rDefault, cDefault);
        
        TablePanel balloonDisplay = new TablePanel(new Object[][]{
            {labelX, xTFV, xSlider},
            {labelY, yTFV, ySlider},
            {labelR, rTFV, rSlider},
            {"", "Color:", cView}},
            VERTICAL, 1, 1);
        
        return balloonDisplay;        	
                	        
    }
    

    /** The slider sliding action. */
    protected SimpleAction slideAction =
        new SimpleAction("Sliding Action") {
            public void perform() { slidingAction(); }
        };

	/**
	 * Creates three text field views with the desired default values
	 * a ColorView, and three Sliders
	 */
    protected void createTFVTriple(int xDefault, 
                                   int yDefault,
                                   int rDefault,
                                   Color cDefault) {
    
    	xTFV = new TextFieldView(
	        "" + xDefault,
	        "Please enter a real number:",
	        "x coordinate error",
	        80);
	             
    	yTFV = new TextFieldView(
	        "" + yDefault,
	        "Please enter a real number:",
	        "y coordinate error",
	        80);
	        
    	rTFV = new TextFieldView(
	        "" + rDefault,
	        "Please enter a real number:",
	        "y coordinate error",
	        80);
	        
	    cView = new ColorView(cDefault, true);
	        
	    xSlider = new SliderView(HORIZONTAL, 0, 400, xDefault);
	    ySlider = new SliderView(HORIZONTAL, 0, 400, yDefault);
	    rSlider = new SliderView(HORIZONTAL, 0, 400, rDefault);
	        
	    xTFV.setDefaultViewState("" + xDefault);
	    yTFV.setDefaultViewState("" + yDefault);	    
	    rTFV.setDefaultViewState("" + rDefault);	
	    
        xTFV.addActionListener(setValueFromField);
        yTFV.addActionListener(setValueFromField);
        rTFV.addActionListener(setValueFromField);

        pca.addPropertyChangeAction(setValueFromField);
        cView.addPropertyChangeListener(pca);
        
	    xSlider.addSlidingAction(slideAction);    
	    ySlider.addSlidingAction(slideAction);    
	    rSlider.addSlidingAction(slideAction); 
	            	        
    }

    /** The delay slider sliding action method. */
    protected void slidingAction() {
             
        window.clearPanel();
        
        /* record the current state of the view */
        b.setX( xSlider.getValue() );        
        b.setY( ySlider.getValue() );        
        b.setRadius( rSlider.getValue() );        
        b.setColor( cView.getColor() );
        
        /* reset all views and repaint all balloons */
        bd.resetViews();
        window.repaint();
    }


    /* set the view state from the current state of the balloon */
    public void setViewState(){
        xTFV.setViewState("" + b.getX() );
        yTFV.setViewState("" + b.getY() );
        rTFV.setViewState("" + b.getRadius() );
        xSlider.setViewState("" + b.getX());
        ySlider.setViewState("" + b.getY());
        rSlider.setViewState("" + b.getRadius());
        cView.setColor(b.getColor());
    }

    /**
     * Sets the value from all text fields and the color view upon change.
     */
    protected void setValueFromField() {
        b.setX( xTFV.demandInt() );
        xSlider.setViewState("" + b.getX());
        b.setY( yTFV.demandInt() );
        ySlider.setViewState("" + b.getY());
        b.setRadius( rTFV.demandInt() );
        rSlider.setViewState("" + b.getRadius());
        b.setColor( cView.getColor() );
        cView.setColor(b.getColor());
        
        /* reset all views and repaint all balloons */
        bd.resetViews();
        window.repaint();
    }

}