/*
 * @(#)Balloon.java  1.0  30 July 2002
 *
 * @author Viera K. Proulx
 */

import edu.neu.ccs.gui.*;	// to get BufferedPanel
import java.awt.*;			// to get Color
import java.awt.geom.*;		// to get Graphics2D functionality

/** A simple class to represent a balloon. */
class Balloon {
    
    /*-------------------------------------------------------------------------
     Member data 
     *-----------------------------------------------------------------------*/
    
    /** center of the balloon */
    Point loc;

    /** the radius of the balloon */
    int rad;

    /** the color of the balloon */
    Color col;

    /*-------------------------------------------------------------------------
     Constructor
     *-----------------------------------------------------------------------*/
    
    /** cookie cutter consturctor */
    public Balloon (int some_x, int some_y, int some_radius, Color some_color){
        // Code needs to be added here...
    }
    
    /** copy constructor */
    public Balloon(Balloon someBalloon){
    	// Code needs to be added here...
    }

    /** default constructor */
    public Balloon(){
    	// Code needs to be added here...
    }

    /*-------------------------------------------------------------------------
     Methods 
     *-----------------------------------------------------------------------*/
    
    /** get the x location of the balloon */
    int getX(){
    	return loc.x;
    }
    
    /** get the y location of the balloon */
    int getY(){
    	return loc.y;
    }
    
    /** get the radius of the balloon */
    int getRadius(){
    	return rad;
    }
    
    /** get the color of the balloon */
    Color getColor(){
    	return col;
    }
    
    /** compute the diameter of the balloon */
    int getDiameter(){
        return 2 * this.getRadius();
    }
    
    /** set the x location of the balloon */
    void setX(int some_x){
    	if( loc==null ) loc = new Point( some_x, 0 );
    	else loc.setLocation( some_x, loc.getY() );
    }
    
    /** set the y location of the balloon */
    void setY(int some_y){
    	if( loc==null ) loc = new Point( 0, some_y );
    	else loc.setLocation( loc.getX(), some_y );
    }
    
    /** set the radius of the balloon */
    void setRadius(int some_radius){
    	rad = some_radius;
    }
    
    /** set the color of the balloon */
    void setColor(Color some_color){
    	col = some_color;
    }
    
    /** compute the distance of this balloon from the top of window */
    int distanceFromTop(){
    	return this.getY() - this.getRadius();
    }

    /** compare the top of this and the given other balloon */
    boolean isHigherThan(Balloon otherBln){
        return this.distanceFromTop() < otherBln.distanceFromTop() ;
    }
        
    /** show balloon in the given buffered panel window */
    void paintBalloon(BufferedPanel window){
        
        if (window == null)
            return;
            
        // get graphics context and set the color
        Graphics2D G = window.getBufferGraphics();
        G.setPaint(getColor());
        
        // paint the ballon
        Ellipse2D.Double E = 
            new Ellipse2D.Double(this.getX() - this.getRadius(), this.getY() - this.getRadius(), 
                                 this.getDiameter(), this.getDiameter());
        G.fill(E);
        
        // paint the string
        Line2D.Double L =
            new Line2D.Double(this.getX(), this.getY() + this.getRadius(), this.getX(), this.getY() + 3 * this.getRadius());
        G.draw(L);
        window.repaint();
    }
    
    /*
    public Object clone() throws CloneNotSupportedException {
    }
    */
    
    /** print the balloon data */
    public String toString(){
    	return ("new " + getClass() + "(" + 
    	        this.getX() + ", " + 
    	        this.getY() + ", " + 
    	        this.getRadius() + ", " + 
    	        this.getColor() + ")");
    }
    
}
