/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AbsoluteLayout;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Zoo;
import edu.neu.ccs.gui.ZooGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.util.Vector;
import javax.swing.JComponent;

public class ZooContainer
extends DisplayPanel {
    public ZooContainer() {
        this.setLayout(new AbsoluteLayout());
    }

    public Component addChildItem(Component c) {
        return this.addChildItemImpl(c, 0);
    }

    public Component addChildItem(Component c, int z) {
        return this.addChildItemImpl(c, z);
    }

    public Component findItemAt(int x, int y) {
        return this.findItemImpl(x, y, true);
    }

    public Component findItemAt(Point p) {
        return this.findItemImpl(p.x, p.y, true);
    }

    public Component findChildItemAt(int x, int y) {
        return this.findItemImpl(x, y, false);
    }

    public Component findChildItemAt(Point p) {
        return this.findItemImpl(p.x, p.y, false);
    }

    public Component getItem(int index) {
        return this.getItems()[index];
    }

    public Component[] getItems() {
        Vector<Component> items = new Vector<Component>();
        Component c = null;
        ZooGroup group = null;
        Component[] child = null;
        int i = 0;
        while (i < this.getComponentCount()) {
            c = this.getComponent(i);
            if (c instanceof ZooGroup) {
                group = (ZooGroup)c;
                child = group.getItems();
                int j = 0;
                while (j < child.length) {
                    items.add(child[j]);
                    ++j;
                }
            } else {
                items.add(c);
            }
            ++i;
        }
        return items.toArray(new Component[0]);
    }

    public int getItemCount() {
        return this.getItems().length;
    }

    public int inverseGetItem(Component c) {
        Component[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Component getChildItem(int z) {
        return this.getComponent(z);
    }

    public Component[] getChildItems() {
        return this.getComponents();
    }

    public int getChildItemCount() {
        return this.getComponentCount();
    }

    public int inverseGetChildItem(Component c) {
        Component[] child = this.getChildItems();
        int i = 0;
        while (i < child.length) {
            if (child[i] == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ZooContainer getParentContainer(Component c) {
        Component[] child = this.getChildItems();
        int i = 0;
        while (i < child.length) {
            if (child[i] == c) {
                return this;
            }
            ++i;
        }
        ZooGroup group = null;
        ZooContainer parent = null;
        int i2 = 0;
        while (i2 < child.length) {
            if (child[i2] instanceof ZooGroup && (parent = (group = (ZooGroup)child[i2]).getParentContainer(c)) != null) {
                return parent;
            }
            ++i2;
        }
        return null;
    }

    public Zoo getRootZoo() {
        Container c = this;
        while (c != null && c instanceof ZooContainer) {
            c = c.getParent();
        }
        if (c instanceof Zoo) {
            return (Zoo)c;
        }
        return null;
    }

    public Zoo getAncestorZoo() {
        if (this.getRootZoo() == this) {
            return (Zoo)this;
        }
        Container c = this;
        while (c != null) {
            if (!((c = c.getParent()) instanceof Zoo)) continue;
            return (Zoo)c;
        }
        return null;
    }

    public Component removeChildItem(Component c) {
        return this.removeChildItemImpl(c);
    }

    public Component removeChildItem(int z) {
        return this.removeChildItemImpl(this.getChildItem(z));
    }

    public void removeAllItems() {
        this.removeAll();
    }

    public int bringToFront(Component c) {
        return this.moveToZOrder(c, 0);
    }

    public int sendToBack(Component c) {
        return this.moveToZOrder(c, this.getChildItemCount() - 1);
    }

    public int moveUp(Component c) {
        int z = this.inverseGetChildItem(c);
        if (z == -1) {
            return -1;
        }
        int newZ = this.nextHigherInZOrder(z);
        return this.moveToZOrder(c, newZ);
    }

    public int moveDown(Component c) {
        int z = this.inverseGetChildItem(c);
        if (z == -1) {
            return -1;
        }
        int newZ = this.nextDeeperInZOrder(z);
        return this.moveToZOrder(c, newZ);
    }

    public int moveToZOrder(Component c, int newZ) {
        if (newZ < 0 || newZ > this.getChildItemCount()) {
            throw new ArrayIndexOutOfBoundsException("Z-order is invalid: " + newZ);
        }
        int z = this.inverseGetChildItem(c);
        if (z == -1) {
            return -1;
        }
        if (z == newZ) {
            return z;
        }
        this.removeChildItem(c);
        this.addChildItem(c, newZ);
        return newZ;
    }

    public int nextHigherInZOrder(int z) {
        if (z < 0 || z > this.getChildItemCount()) {
            throw new ArrayIndexOutOfBoundsException("Z-order is invalid: " + z);
        }
        Component[] child = this.getChildItems();
        int i = z - 1;
        while (i > 0) {
            if (child[i].isVisible() && child[i].getBounds().intersects(child[z].getBounds())) {
                return i;
            }
            --i;
        }
        return 0;
    }

    public int nextDeeperInZOrder(int z) {
        if (z < 0 || z >= this.getChildItemCount()) {
            throw new ArrayIndexOutOfBoundsException("Z-order is invalid: " + z);
        }
        Component[] child = this.getChildItems();
        int i = z + 1;
        while (i < child.length) {
            if (child[i].isVisible() && child[i].getBounds().intersects(child[z].getBounds())) {
                return i;
            }
            --i;
        }
        return child.length - 1;
    }

    public ZooGroup group(Component[] components) {
        Vector<Component> valid = new Vector<Component>();
        int temp = 0;
        int z = Integer.MAX_VALUE;
        int i = 0;
        while (i < components.length) {
            temp = this.inverseGetChildItem(components[i]);
            if (temp > -1) {
                valid.add(components[i]);
                if (temp < z) {
                    z = temp;
                }
            }
            ++i;
        }
        if (valid.size() < 2) {
            return null;
        }
        Component above = z == 0 ? null : this.getChildItem(z - 1);
        int i2 = 0;
        while (i2 < valid.size()) {
            this.removeChildItem((Component)valid.get(i2));
            ++i2;
        }
        ZooGroup group = new ZooGroup(valid);
        z = above == null ? 0 : this.inverseGetChildItem(above) + 1;
        this.addChildItem(group, z);
        return group;
    }

    public Component[] ungroup(ZooGroup group) {
        int z = this.inverseGetChildItem(group);
        if (z == -1) {
            return new Component[0];
        }
        Component above = z == 0 ? null : this.getChildItem(z - 1);
        Component[] components = group.getComponents();
        this.removeChildItem(group);
        z = above == null ? 0 : this.inverseGetChildItem(above) + 1;
        int i = 0;
        while (i < components.length) {
            components[i].setLocation(components[i].getX() + group.getX(), components[i].getY() + group.getY());
            this.addChildItem(components[i], z++);
            ++i;
        }
        return components;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return false;
    }

    private Component addChildItemImpl(Component c, int z) {
        if (c == null) {
            return null;
        }
        return this.add(c, z);
    }

    private Component findItemImpl(int x, int y, boolean recurse) {
        if (!this.contains(x, y)) {
            return null;
        }
        Component[] components = this.getChildItems();
        Component found = this;
        int i = 0;
        while (i < components.length) {
            if (components[i].isVisible() && components[i].contains(x, y)) {
                found = components[i];
                if (!recurse || !(found instanceof ZooContainer)) break;
                Component child = found;
                found = ((Container)child).findComponentAt(x - ((JComponent)child).getX(), y - ((JComponent)child).getY());
                break;
            }
            ++i;
        }
        return found;
    }

    private Component removeChildItemImpl(Component c) {
        Component[] child = this.getChildItems();
        int i = 0;
        while (i < child.length) {
            if (child[i] == c) {
                this.remove(c);
                return c;
            }
            ++i;
        }
        return null;
    }
}

