/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.math.BigInteger;
import java.text.ParseException;

public class XBigInteger
extends XNumber {
    private BigInteger value = BigInteger.ZERO;

    public XBigInteger() {
    }

    public XBigInteger(BigInteger b) {
        this.setValue(b);
    }

    public XBigInteger(String s) throws ParseException {
        this.fromStringData(s);
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException("Input was null.", -1);
        }
        BigInteger oldValue = this.value;
        Parser p = ParserUtilities.getDefaultParser();
        Object obj = p.parse(data);
        if (!(obj instanceof XNumber)) {
            throw new ParseException("Expected numeric value.", data.length());
        }
        XBigInteger x = ParserUtilities.toXBigInteger((XNumber)obj);
        this.value = x.getValue();
        this.changeAdapter.firePropertyChange("value", oldValue, data);
    }

    public String toStringData() {
        return this.value.toString();
    }

    public byte byteValue() {
        BigInteger max = new BigInteger("127");
        BigInteger min = new BigInteger("-128");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue().intValue();
    }

    public short shortValue() {
        BigInteger max = new BigInteger("32767");
        BigInteger min = new BigInteger("-32768");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue().intValue();
    }

    public int intValue() {
        BigInteger max = new BigInteger("2147483647");
        BigInteger min = new BigInteger("-2147483648");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of an int.");
        }
        return this.getValue().intValue();
    }

    public long longValue() {
        BigInteger max = new BigInteger("9223372036854775807");
        BigInteger min = new BigInteger("-9223372036854775808");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of a long.");
        }
        return this.getValue().longValue();
    }

    public float floatValue() {
        return this.getValue().floatValue();
    }

    public double doubleValue() {
        return this.getValue().doubleValue();
    }

    public boolean equals(Object other) {
        if (other instanceof XBigInteger) {
            return this.getValue().equals(((XBigInteger)other).getValue());
        }
        return this.getValue().equals(other);
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    public void setValue(BigInteger b) {
        BigInteger oldValue = this.value;
        if (b == null) {
            b = BigInteger.ZERO;
        }
        this.value = b;
        if (!this.getValue().equals(oldValue)) {
            this.changeAdapter.firePropertyChange("value", oldValue, this.getValue());
        }
    }

    public BigInteger getValue() {
        return this.value;
    }

    public static BigInteger[] toPrimitiveArray(XBigInteger[] x) {
        if (x == null) {
            return null;
        }
        BigInteger[] temp = new BigInteger[x.length];
        int i = 0;
        while (i < temp.length) {
            if (x[i] != null) {
                temp[i] = x[i].getValue();
            }
            ++i;
        }
        return temp;
    }

    public static XBigInteger[] toXArray(BigInteger[] a) {
        if (a == null) {
            return null;
        }
        XBigInteger[] temp = new XBigInteger[a.length];
        int i = 0;
        while (i < temp.length) {
            if (a[i] != null) {
                temp[i] = new XBigInteger(a[i]);
            }
            ++i;
        }
        return temp;
    }
}

