/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import java.math.BigDecimal;
import java.text.ParseException;

public class XBigDecimal
extends XNumber {
    private BigDecimal value = new BigDecimal(0.0);

    public XBigDecimal() {
    }

    public XBigDecimal(BigDecimal b) {
        this.setValue(b);
    }

    public XBigDecimal(String s) throws ParseException {
        this.fromStringData(s);
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException("Input was null.", -1);
        }
        BigDecimal oldValue = this.value;
        try {
            this.setValue(new BigDecimal(data));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Not a valid BigDecimal.", data.length());
        }
        this.changeAdapter.firePropertyChange("value", oldValue, data);
    }

    public String toStringData() {
        return this.value.toString();
    }

    public byte byteValue() {
        BigDecimal max = new BigDecimal("127");
        BigDecimal min = new BigDecimal("-128");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue().intValue();
    }

    public short shortValue() {
        BigDecimal max = new BigDecimal("32767");
        BigDecimal min = new BigDecimal("-32768");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue().intValue();
    }

    public int intValue() {
        BigDecimal max = new BigDecimal("2147483647");
        BigDecimal min = new BigDecimal("-2147483648");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of an int.");
        }
        return this.getValue().intValue();
    }

    public long longValue() {
        BigDecimal max = new BigDecimal("9223372036854775807");
        BigDecimal min = new BigDecimal("-9223372036854775808");
        if (this.getValue().compareTo(max) > 0 || this.getValue().compareTo(min) < 0) {
            throw new NumberFormatException("Number beyond precision of a long.");
        }
        return this.getValue().longValue();
    }

    public float floatValue() {
        return this.getValue().floatValue();
    }

    public double doubleValue() {
        return this.getValue().doubleValue();
    }

    public boolean equals(Object other) {
        if (other instanceof XBigDecimal) {
            return this.getValue().equals(((XBigDecimal)other).getValue());
        }
        return this.getValue().equals(other);
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    public void setValue(BigDecimal b) {
        BigDecimal oldValue = this.value;
        if (b == null) {
            b = new BigDecimal(0.0);
        }
        this.value = b;
        if (!this.getValue().equals(oldValue)) {
            this.changeAdapter.firePropertyChange("value", oldValue, this.getValue());
        }
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public static BigDecimal[] toPrimitiveArray(XBigDecimal[] x) {
        if (x == null) {
            return null;
        }
        BigDecimal[] temp = new BigDecimal[x.length];
        int i = 0;
        while (i < temp.length) {
            if (x[i] != null) {
                temp[i] = x[i].getValue();
            }
            ++i;
        }
        return temp;
    }

    public static XBigDecimal[] toXArray(BigDecimal[] a) {
        if (a == null) {
            return null;
        }
        XBigDecimal[] temp = new XBigDecimal[a.length];
        int i = 0;
        while (i < temp.length) {
            if (a[i] != null) {
                temp[i] = new XBigDecimal(a[i]);
            }
            ++i;
        }
        return temp;
    }
}

