/* 
TestSuite.java  26 February 2003 */


import java.awt.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.math.*;
import java.util.*;

public class TestSuite extends JPFalt 
{
    public static void main(String[] args) { new TestSuite(); }
    
    ///////////////////////////////////////////////////////////
    // Place your actual methods here.                       //
    ///////////////////////////////////////////////////////////
	 	
	/*----------------------------------------------------------------------- 
	 Test server socket and iterator for input of series of lines
	------------------------------------------------------------------------- */
	public void TestSocketServer(){
	
		String inputLine;
		
		AsciiSocket as=new AsciiSocket();
		
		println("Waiting for an incoming connection on port " 
		        +AsciiSocket.DEFAULT_PORT+"...");
		        
		/* establish a connection */
		if(as.listenOn()){
			println("Connected!!!");
			as.writeLine("Hi im an example echo server socket... " + 
			             "I'll repeat every line you say");
			
			for(IRange it=as.lineIRange(); 
			    it.hasMore(); 
			    it.next()){
			    
				inputLine = (String)it.current();
				println(inputLine);
				as.writeLine("You typed: " + inputLine);
				
				if (inputLine.equals("Disconnect"))
					as.close();
			}
			
			println("Disconnected");
		}
		
		else{
			println("Could not bind ServerSocket");
		}
	}
	
	/*----------------------------------------------------------------------- 
	 Test client socket and iterator for input of series of lines
	------------------------------------------------------------------------- */
	public void TestSocketClient(){
	
		String inputLine;
		
		AsciiSocket as=new AsciiSocket();
		
		println("Trying to connecto to localhost:"+AsciiSocket.DEFAULT_PORT+"...");
		String host = console.in.demandString("Connect to:");

		/* establish a connection */
		if(as.connectTo(host)){
			println("Connected!!!");
			as.writeLine("Hi im an example echo client socket... " + 
			             "I'll repeat every line you say");

			for(IRange it=as.lineIRange(); 
			    it.hasMore(); 
			    it.next()){	
			    inputLine = (String)it.current();
				println("Recived line from socket: "+ inputLine);
				as.writeLine(console.in.demandString("Your turn to type:"));

				if (inputLine.equals("Disconnect"))
					as.close();
			}
			
			println("Disconnected");
		}
		
		else{
			println("Could not bind ServerSocket");
		}
	}
	
	/* simplified server socket connection */
	public void TestSimpleSocketEcho(){
	
		String inputLine;
		
		AsciiSocket as=new AsciiSocket();
		String hostid = console.in.demandString("Your id:");
		
		if(as.listenOn()){
			as.writeLine(hostid + " ready");
			
			for(IRange it=as.lineIRange(); 
			    it.hasMore(); 
			    it.next()){
			    
				inputLine = (String)it.current();
				println(inputLine);
				as.writeLine("You typed: "+it.current());
			}
			
			println("Disconnected");
		}
		
		else{
			println("Could not bind ServerSocket");
		}
	}
	

	/*----------------------------------------------------------------------- 
	 Test socket iterator for input of series of lines
	------------------------------------------------------------------------- */
    void TestSocketRange(){
    
		String inputLine;
		String host = console.in.demandString("Name to connect to:");
		
		int n = 5;
		        
        for (IRange it = new SocketRange(host);
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            
            println("You typed: " + inputLine);
            n = n-1;
            if (n == 0)
            	((SocketRange)it).disconnect();
        }
        println("Done with socket range.");        
    }
        
	/*----------------------------------------------------------------------- 
	 Test console iterator for input of series of lines
	------------------------------------------------------------------------- */
    void TestInConsoleRangeEcho(){
    
		String inputLine;
		        
        for (IRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            
            println("You typed: " + inputLine);
        }        
    }
        
	/*----------------------------------------------------------------------- 
	 Test console iterator for input of series of lines, with user responses
	-----------------------------------------------------------------------*/
    void TestInConsoleRangeReply(){
    
		String inputLine;
		String response;
		        
        for (IRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            println("Received from input stream: " + inputLine);
            
            response = console.in.demandString("Please, reply: ");
            println("Posted to output stream: " + response);
        }        
    }
        
	/*----------------------------------------------------------------------- 
	 Test console iterator for input of series of numbers
	-----------------------------------------------------------------------*/
    void TestInConsoleRangeIntegers(){
    
		String inputLine;
		int number;
		        
        for (IRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            number = (new Integer(inputLine)).intValue();
            
            println("You typed: " + 2 * number);
            
        }        
    }

	/*----------------------------------------------------------------------- 
	 Test console iterator with NumberGame
	-----------------------------------------------------------------------*/
    void TestNumberGame(){
    
		NumberGame ng = new NumberGame(0, 100);
		
		String inputLine;
		int number;
		        
        for (IRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            number = (new Integer(inputLine)).intValue();
            
            println(ng.replyToGuess(number));
        }        
    }
    
	/*----------------------------------------------------------------------- 
	 Test socket iterator with NumberGame
	-----------------------------------------------------------------------*/
    void TestSocketNumberGame(){
    
    	AsciiSocket as = new AsciiSocket();
    	
		NumberGame ng = new NumberGame(0, 100);
		
		String inputLine;
		int number = ng.low;
		
		println("Waiting for an incoming number game connection on port "
		        + AsciiSocket.DEFAULT_PORT + "...");
		
		if (as.listenOn()){
			
			println("Connection has been made!");
			as.writeLine("Welcome to the Number Game");
		        
	        for (IRange it = new InConsoleRange();
	             it.hasMore();
	             it.next()){
	        	
	        	/* receive the guess */
	            inputLine = (String)it.current();
	            println("Server received: " + inputLine);
	            if (isNumber(inputLine))
	            	number = (new Integer(inputLine)).intValue();
	            
	            /* reply to the guess */
	            as.writeLine(ng.replyToGuess(number));	            
	            println(ng.replyToGuess(number));
	            
	            if (ng.replyToGuess(number).equals("BINGO!!!"))
	            	as.close();
	        }
	        
	    	println("Disconnected");
	    }
	    
	    else{
	    	println("Could not bind ServerSocket");
	    }
    }
    
    protected boolean isNumber(String s){
    	
    	StringTokenizer st = new StringTokenizer(s, "0123456789");
    	return !(st.hasMoreTokens());
    }
    
    public void TestIsNumber(){
    
    	expected(true);
    	actual(isNumber("1224"));
    	
    	expected(false);
    	actual(isNumber("s123"));
    	
    	expected(false);
    	actual(isNumber("123."));
    	
    	expected(false);
    	actual(isNumber("12 3"));
    	
    	
    }
    
	/*----------------------------------------------------------------------- 
	 Test client side of Number Game
	------------------------------------------------------------------------- */
	public void TestClientNumberGame(){
	
		String inputLine;
		
		AsciiSocket as=new AsciiSocket();
		
		println("Trying to connecto to localhost:"+AsciiSocket.DEFAULT_PORT+"...");
		String host = console.in.demandString("Connect to:");

		/* establish a connection */
		if(as.connectTo(host)){
			println("Connected!!!");
			as.writeLine("Ready to play the game.");

			for(IRange it=as.lineIRange(); 
			    it.hasMore(); 
			    it.next()){	
			    inputLine = (String)it.current();
			    println("Client received: " + inputLine);
				as.writeLine(console.in.demandString(inputLine));

				if (inputLine.equals("Disconnect"))
					as.close();
			}
			
			println("Disconnected");
		}
		
		else{
			println("Could not bind ServerSocket");
		}
	}
	
	/*----------------------------------------------------------------------- 
	 Test Battleships
	-----------------------------------------------------------------------*/
    void TestBattleShips(){
    	PlayBattleShips game = new PlayBattleShips(10, window);

		game.play();
    }

	/*----------------------------------------------------------------------- 
	 Test console iterator with Eliza
	-----------------------------------------------------------------------*/
    void TestEliza(){
    
		Eliza liz = new Eliza();
		
		String inputLine;
		        
        for (IRange it = new InConsoleRange();
             it.hasMore();
             it.next()){
        
            inputLine = (String)it.current();
            
            println(liz.selectAnswer(inputLine));
        }        
    }
    
}

