/* 
PlayBattleShips.java  22 May 2003 */


import java.awt.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.awt.*;
import java.math.*;

public class PlayBattleShips implements ConsoleAware{
	 	
	/*----------------------------------------------------------------------- 
	 Constants
	-----------------------------------------------------------------------*/
	
	public static int WATER = 0;
	public static int SHIP  = 1;
	public static int MISS  = 2;
	public static int HIT   = 3;
	public static int WIN   = 4;
	public static int REPEAT = 5;
	
	/*----------------------------------------------------------------------- 
	 Member data
	-----------------------------------------------------------------------*/
	public int myguesses[][] = new int[][]{ {0,0,0,0,0,0,0,0,0,0},
	                                        {0,0,0,0,0,0,0,0,0,0},
	                                        {0,0,0,0,0,0,0,0,0,0},
	                                        {0,0,0,0,0,0,0,0,0,0},
	                                        {0,0,0,0,0,0,0,0,0,0},
	                                        {0,0,0,0,0,0,0,0,0,0},
	                                        {0,0,0,0,0,0,0,0,0,0},
	                                        {0,0,0,0,0,0,0,0,0,0},
	                                        {0,0,0,0,0,0,0,0,0,0},
	                                        {0,0,0,0,0,0,0,0,0,0} };
	
	/* the opponent */
	public BattleShips enemy = new BattleShips(10);
	
	/* total number of turns takes */
	public int noTurns = 0;
	
	/* total number of places taken by ships */
	public int noShips = 14;
	
	/* total number of hits so far */
	public int noHits = 0;
	
	/* size of the board used in this game */
	public int size = 10;
	
	/* the window for the display - will be refactored out */
	public BufferedPanel window;
		
	/*----------------------------------------------------------------------- 
	 Constructors
	------------------------------------------------------------------------- */
	public PlayBattleShips(int n, BufferedPanel _window){
		
		if ((n > 0) && (n <= 10))
			this.size = n;
			
		this.window = _window;
		
	}
        
	public PlayBattleShips(BufferedPanel _window){

		this(10, _window);
	}
              
        
	/*----------------------------------------------------------------------- 
	 Make guesses 
	-----------------------------------------------------------------------*/
    public void play(){
    
    	boolean win = false;
    	int result;
    	
    	while (!win){
    	
	    	noTurns++;
	    	Point p = nextGuess();
	    	result = enemy.replyToGuess(p.x, p.y);
	    	
	    	if (result == WIN){
	    		myguesses[p.x][p.y] = HIT;
	    		noHits++;
	    		win = true;
	    		console.out.println("I win!!!");
	    	}
	    	
	    	else if (result == HIT){
	    		myguesses[p.x][p.y] = HIT;
	    		noHits++;
	    	}
	    	
	    	else if (result == MISS){
	    		myguesses[p.x][p.y] = MISS;
	    	}
	    	
	    	else
	    		System.out.println("Repeat guess, me, fool");
    	
    		enemy.showBoard(window);
    	}
    }
    
    public Point nextGuess(){
    	
    	int row = console.in.demandInt("Guess the row:");
    	int col = console.in.demandInt("Guess the column:");
    	
    	while (! ((row > 0) && (row <= size) && 
    	          (col > 0) && (col <= size))){
    		console.out.println("Incorrect guess - try again.");
    		row = console.in.demandInt("Guess the row:");
    		col = console.in.demandInt("Guess the column:");
    	}
    	
    	return new Point(col - 1, row - 1);
    	
    }
        
	/*----------------------------------------------------------------------- 
	 Print all member data
	-----------------------------------------------------------------------*/
	public String toString(){
		return ("new " + getClass().getName() + "(" +
		        this.noTurns  + ", " + 
		        this.noShips  + ", " + 
		        this.noHits   +  ")");
	}
}

