/*
 * AsciiSocket.java @ April 21, 2002
 * by Jason Ansel <jansel@ccs.neu.edu>
 *
 * This class converts java iterators to COM 1201 style IRanges
 *
 */
import java.util.Iterator;

class IteratorIRange implements IRange{
	Iterator iterator;
	Object current;
	boolean hasCurrent;
	
	IteratorIRange(Iterator i){
		iterator=i;
		next();
	}
	
	/* move the cursor one forward, assuming it is a Cons */
    public void next(){
    	if(this.iterator.hasNext()){
    		current=iterator.next();
    		hasCurrent=true;
    	}else{
    		hasCurrent=false;
    	}
    }
    
    /* select the item to which the cursor points */
    public Object current(){
    	return current;
    } 
    
    /* test whether there are more items in the range */
    public boolean hasMore(){
    	return hasCurrent;
    }

}